/*
* Licensed Materials - Property of IBM* and/or HCL**
* UrbanCode Build
* (c) Copyright IBM Corporation 2016, 2017. All Rights Reserved.
* (c) Copyright HCL Technologies Ltd. 2018. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*
* * Trademark of International Business Machines
* ** Trademark of HCL Technologies Limited
*/

import com.urbancode.air.AirPluginTool
import com.urbancode.air.plugin.salesforce.SalesForceHelper

final airTool = new AirPluginTool(args[0], args[1])
final def props = airTool.getStepProperties()

final def workDir = new File('.').canonicalFile

String password = props['automation/password']
String username = props['automation/username']
String serverUrl = props['automation/serverUrl']
String apiVersion = props['apiVersion']

def helper = new SalesForceHelper(props)
AntBuilder ant = helper.buildAnt()

println("[ACTION] Describing metadata from ${serverUrl}...")

ant.taskdef name: "sfDescribeMetadata", classname: "com.salesforce.ant.DescribeMetadataTask"
ant.sfDescribeMetadata(
        username: username,
        password: password,
        serverurl: serverUrl,
        apiVersion: apiVersion
)
