/*
* Licensed Materials - Property of IBM* and/or HCL**
* UrbanCode Build
* (c) Copyright IBM Corporation 2016, 2017. All Rights Reserved.
* (c) Copyright HCL Technologies Ltd. 2018. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*
* * Trademark of International Business Machines
* ** Trademark of HCL Technologies Limited
*/

import com.urbancode.air.AirPluginTool
import com.urbancode.air.plugin.salesforce.SalesForceHelper

final airTool = new AirPluginTool(args[0], args[1])
final def props = airTool.getStepProperties()

final def workDir = new File('.').canonicalFile

String retrieveType = props['retrieveType']
String password = props['automation/password']
String username = props['automation/username']
String serverUrl = props['automation/serverUrl']
String packageNames = props['packageNames']
String retrieveTarget = props['retrieveTarget']
String maxPoll = props['maxPoll']?:"200"
String pollWaitMillis = props['pollWaitMillis']?:"10000"
String unpackaged = props['unpackaged']

if (packageNames != "" && unpackaged != "") {
    println("[WARNING] 'packageNames' and 'unpackaged' were both specified, but only one can be used.")
}

// Throw error at the beginning if Package Names or Unpackaged are not specified
if (retrieveType == "retrieveUnpackaged" || retrieveType == "retrieveCode" && unpackaged == "") {
    throw new Exception("Unpackaged is required for retrieveType 'Unpackaged' or 'Code'")
}

if (retrieveType == "retrievePkg" || retrieveType == "retrieveOutput" && packageNames == "") {
    throw new Exception("Package Names is required for retrieveType 'retrievePkg' or 'retrieveOutput'")
}

def helper = new SalesForceHelper(props)
AntBuilder ant = helper.buildAnt()

println("[ACTION] Retrieving from ${retrieveTarget}")

ant.taskdef name: "sfRetrieve", classname: "com.salesforce.ant.RetrieveTask"

if (retrieveType == "retrieveUnpackaged" || retrieveType == "retrieveCode") {
    ant.sfRetrieve(
            username: username,
            retrieveTarget: retrieveTarget,
            unpackaged: unpackaged,
            password: password,
            serverurl: serverUrl,
            maxPoll: maxPoll,
            pollWaitMillis: pollWaitMillis
    )
}
else {
    ant.sfRetrieve(
            username: username,
            retrieveTarget: retrieveTarget,
            packageNames: packageNames,
            password: password,
            serverurl: serverUrl,
            maxPoll: maxPoll,
            pollWaitMillis: pollWaitMillis
    )
}
