/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Deploy
* (c) Copyright IBM Corporation 2017, 2018. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/

package com.urbancode.air.plugins.accurev.objects

public class Stream {

    private String name
    private String basis
    private String basisStreamNumber
    private String depotName
    private String streamNumber
    private String isDynamic
    private String type
    private String time // Snapshots only
    private String startTime
    private String hasProperties

    public Stream (def it) {
        this.name = it?.@name.text()
        this.basis = it?.@basis.text()
        this.basisStreamNumber = it?.@basisStreamNumber.text()
        this.depotName = it?.@depotName.text()
        this.streamNumber = it?.@streamNumber.text()
        this.isDynamic = it?.@isDynamic.text()
        this.type = it?.@type.text()
        this.startTime = it.@startTime.text()
        this.hasProperties = it?.@hasProperties.text()
        if (isSnapshot()) {
            this.time = it?.@time.text()
        } else {
            this.time = -1
        }
    }

    public String getName() {
        return name
    }

    public String getType() {
        return type
    }

    public String getDepot() {
        return depotName
    }

    public String getBasis() {
        return basis
    }

    public String getTime() {
        if (type != "snapshot") {
            println "[Warn] Called getTime() on a non-snapshot stream."
        }
        return time
    }

    public boolean isStream() {
        return this.type == "normal"
    }

    public boolean isSnapshot() {
        return this.type == "snapshot"
    }

    public boolean isWorkspace() {
        return this.type == "workspace"
    }

    // Debugging purposes only
    public void print() {
        println "================"
        println "name: " + name
        println "basis: " + basis
        println "basisStreamNumber: " + basisStreamNumber
        println "depotName: " + depotName
        println "streamNumber: " + streamNumber
        println "isDynamic: " + isDynamic
        println "type: " + type
        println "time: " + time
        println "startTime: " + startTime
        println "hasProperties: " + hasProperties
        println "================"
    }
}
