/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Deploy
* (c) Copyright IBM Corporation 2017, 2018. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/

package com.urbancode.air.plugins.accurev.objects

public class Issue {

    private String versionName
    private String issueNum
    private String transNum
    private String shortDescription
    private List<Change> changes

    public Issue (def it) {
        this.issueNum = it?.issueNum.text()
        this.transNum = it?.transNum.text()
        this.shortDescription = it?.shortDescription.text()
        this.changes = new ArrayList<Change>()
        this.versionName = "Issue #" + issueNum
    }

    public String getVersionName() {
        return versionName
    }

    public String getIssueNum() {
        return issueNum
    }

    public String getTransNum() {
        return transNum
    }

    public String getShortDescription() {
        return shortDescription
    }

    public List<Change> getChanges() {
        return changes
    }

    public void setChanges(List<Change> changes) {
        this.changes = changes
    }

    // Debugging purposes only
    public void print() {
        println "issueNum: " + getIssueNum()
        println "transNum: " + getTransNum()
        println "shortDescription: " + getShortDescription()
    }
}
