/*
 * Licensed Materials - Property of IBM* and/or HCL**
 * UrbanCode Deploy
 * (c) Copyright IBM Corporation 2017. All Rights Reserved.
 * (c) Copyright HCL Technologies Ltd. 2018. All Rights Reserved.
 *
 * U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
 * GSA ADP Schedule Contract with IBM Corp.
 *
 * * Trademark of International Business Machines
 * ** Trademark of HCL Technologies Limited
 */

package com.urbancode.air.plugins.accurev.objects

public class Change {

    private String  id
    private String real_version
    private String basis_version
    private String realNamedVersion
    private String basisNamedVersion
    private String location
    private String dir
    private String elemType


    public Change (def it) {
        this.id = it?.@id.text()
        this.real_version = it?.@real_version.text()
        this.basis_version = it?.@basis_version.text()
        this.realNamedVersion = it?.@realNamedVersion.text()
        this.basisNamedVersion = it?.@basisNamedVersion.text()
        this.location = it?.@location.text()
        this.dir = it?.@dir.text()
        this.elemType = it?.@elemType.text()
    }

    public String getId() {
        return id
    }

    public String getRealVersion() {
        return real_version
    }

    public String getBasisVersion() {
        return basis_version
    }

    public String getRealNamedVersion() {
        return realNamedVersion
    }

    public String getBasisNamedVersion() {
        return basisNamedVersion
    }

    public String getLocation() {
        return location
    }

    public String getDir() {
        return dir
    }

    public String getElemType() {
        return elemType
    }

    // Debugging purposes only
    public void print() {
        println "id: " + id
        println "real_version: " + real_version
        println "basis_version: " + basis_version
        println "realNamedVersion: " + realNamedVersion
        println "basisNamedVersion: " + basisNamedVersion
        println "location: " + location
        println "dir: " + dir
        println "elemType: " + elemType
    }
}
