/*
 * Licensed Materials - Property of IBM* and/or HCL**
 * UrbanCode Deploy
 * (c) Copyright IBM Corporation 2017. All Rights Reserved.
 * (c) Copyright HCL Technologies Ltd. 2018. All Rights Reserved.
 *
 * U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
 * GSA ADP Schedule Contract with IBM Corp.
 *
 * * Trademark of International Business Machines
 * ** Trademark of HCL Technologies Limited
 */

package com.urbancode.air.plugins.accurev.objects

public class Issue {

    private String versionName
    private String issueNum
    private String shortDescription
    private List<Change> changes

    public Issue (def it) {
        this.issueNum = it?.issueNum.text()
        this.shortDescription = it?.shortDescription.text()
        this.changes = new ArrayList<Change>()
        this.versionName = "Issue #" + issueNum
    }

    public String getVersionName() {
        return versionName
    }

    public String getIssueNum() {
        return issueNum
    }

    public String getShortDescription() {
        return shortDescription
    }

    public List<Change> getChanges() {
        return changes
    }

    public void setChanges(List<Change> changes) {
        this.changes = changes
    }

    // Debugging purposes only
    public void print() {
        println "issueNum: " + getIssueNum()
        println "shortDescription: " + getShortDescription()
    }
}
