#!/bin/bash
echo "-- [IBM UCD]: Install IBM UrbanCode Deploy Agent --"
chmod u+x ./*.sh

################################################################################
# Variables                                                                    #
################################################################################


# Logging and Log File Setup
# --------------------------
STDOUT_LOG=STDOUT
STDERR_LOG=STDERR

################################################################################
# Environment Validation                                                       #
################################################################################

# Ensure that this program is running as root
if [ "`whoami`" != "root" ]; then
    echo "You must run this program as the root user" >&2
    exit 1
fi

if [ -z "$UCD_Agent_Name" ]; then
  echo "ERROR: UCD_Agent_Name not defined; exiting"
  exit 1
else
  echo "UCD_Agent_Name = $UCD_Agent_Name"
fi

if [ -z "$UCD_Hostname" ]; then
  echo "ERROR: UCD_Hostname not defined; exiting"
  exit 1
else
  echo "Connecting to UrbanCode Deploy at '$UCD_Hostname'"
fi

if [ -z "$UCD_Port" ]; then
  echo "ERROR: UCD_Port not defined; exiting"
  exit 1
else
  echo "UCD_Port = $UCD_Port"
fi

# Directory Structure
# -------------------
TMP=/tmp/install_ucd_agent
IBM_UCD_INSTALL_DIR=$TMP/ibm-ucd-agent-install
GROOVY_HOME=$IBM_UCD_INSTALL_DIR/opt/groovy-1.8.8
IBM_UCD_AGENT_DIR=/opt/ibm-ucd/$UCD_Agent_Name


#
# The below section is copied from Groovy 1.8.8's startGroovy
# ...plus the patch for http://jira.codehaus.org/browse/GROOVY-7068
#
# OS specific support (must be 'true' or 'false').
cygwin=false
msys=false
darwin=false
case "`uname`" in
  CYGWIN* )
    cygwin=true
    ;; 
  Darwin* )
    darwin=true
    ;;
  MINGW* )
    msys=true
    ;;
esac

# Attempt to set JAVA_HOME if it's not already set.
if [ -z "$JAVA_HOME" ] ; then
    if $darwin ; then 
        [ -z "$JAVA_HOME" -a -d "/Library/Java/Home" ] && export JAVA_HOME="/Library/Java/Home"
        [ -z "$JAVA_HOME" -a -d "/System/Library/Frameworks/JavaVM.framework/Home" ] && export JAVA_HOME="/System/Library/Frameworks/JavaVM.framework/Home"
    else
        javaExecutable="`which javac 2>/dev/null`"
        if [ -z "$javaExecutable" -o "`expr \"$javaExecutable\" : '\([^ ]*\)'`" = "no" ]; then
            javaExecutable="`which java 2>/dev/null`"
        fi
        [ -z "$javaExecutable" -o "`expr \"$javaExecutable\" : '\([^ ]*\)'`" = "no" ] && die "JAVA_HOME not set and cannot find java to deduce location, please set JAVA_HOME."
        # readlink(1) is not available as standard on Solaris 10.
        readLink=`which readlink`
        [ `expr "$readLink" : '\([^ ]*\)'` = "no" ] && die "JAVA_HOME not set and readlink not available, please set JAVA_HOME."
        javaExecutable="`readlink -f \"$javaExecutable\"`"
        javaHome="`dirname \"$javaExecutable\"`"
        javaHome=`expr "$javaHome" : '\(.*\)/bin'`
        JAVA_HOME="$javaHome"
        export JAVA_HOME
    fi
fi


echo ""
echo ""
echo "-------- START PRINT ENV -----------"
printenv  
echo "-------- END PRINT ENV -------------"
  
################################################################################
# Main Logic                                                                   #
################################################################################

echo "[IBM UCD]: Unzipping IBM UCD Agent to: $TMP"
cd $TMP
unzip -q ./ibm-ucd-agent-*.zip
echo "[IBM UCD]: Configuring installation properties "

$GROOVY_HOME/bin/groovy $TMP/template.groovy $UCD_Agent_Name $UCD_Hostname $UCD_Port

if [ -f "$TMP/agent.install.properties" ]; then
    echo "[IBM UCD]: Installing IBM UCD agent with generated property file"
    $IBM_UCD_INSTALL_DIR/install-agent-from-file.sh $TMP/agent.install.properties
else
    echo "[IBM UCD]: ERROR: Could not find IBM UCD agent properties file for installation."
fi

echo "[IBM UCD]: Starting agent $UCD_Agent_Name"
$IBM_UCD_AGENT_DIR/bin/agent start

