#ps1_sysnative
# Licensed Materials - Property of IBM Corp.
# IBM UrbanCode Build
# IBM UrbanCode Deploy
# IBM UrbanCode Release
# IBM AnthillPro
# (c) Copyright IBM Corporation 2002, 2014. All Rights Reserved.
#
# U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
# GSA ADP Schedule Contract with IBM Corp.
################################################################################
# This script performs a unattended agent installation using a property
# file that contains the necessary installation properties.
# The script requires one argument which is the path to the property file.
################################################################################

Param(
    [parameter(Mandatory=$true)]
    [ValidateNotNull()]
    [alias("n")]
    $UCD_AGENT_NAME,
    [alias("p")]
    $UCD_PORT = "7918",
    [parameter(Mandatory=$true)]
    [ValidateNotNull()]
    [alias("s")]
    $UCD_REMOTE_HOST,
    [alias("l")]
    $PROXY_PORT = "20080",
    [alias("k")]
    $PROXY_HOST,
    [alias("x")]
    $START_OPTION,
    [switch]
    [alias("r")]
    $USE_RELAY,
    [switch]
    [alias("d")]
    $DISABLE_HTTP_FAILOVER,
    [alias("t")]
    $INITIAL_TEAM = "System Team",
    [switch]
    [alias("h")]
    $HELP)

function Expand-ZIPFile($file, $destination)
{
  $shell = new-object -com shell.application
  $zip = $shell.NameSpace($file)
  foreach($item in $zip.items())
  {
    $shell.Namespace($destination).copyhere($item)
  }
}

If ($HELP -eq $true) {
    echo "Usage: install-agent-with-options -n <agent name> -s <UCD remote host URL> -p <agent communication port> -x <start option> -r -k <proxy host> -l <proxy port>"
    echo "  - Agent name: Name of the agent to create"
    echo "  - UCD remote host: Hostname of the remote UCD host the agent should communicate with (UCD server or UCD agent relay)"
    echo "  - Agent communication port: Port over which the agent should communicate with the UCD remote host (Default: 7918, or 7916 when using agent relay)"
    echo "  - Start option (Optional): Start the agent after installation with the specified option (start, run)."
    echo "  - Use Agent Relay (Optional): specify -r to configure agent for agent-relay"
    echo "  - Initial Team (Optional): Comma-separated list of teams to add the agent to when it connects to the server (Default: System Team)"
    echo "  - Proxy host (Optional): Hostname of the proxy server to use with the agent relay (Default: UCD Remote Host)"
    echo "  - Proxy port (Optional): Port of the proxy server to use with the agent relay (Default: 20080)"
    echo "  - Disable http failover (Optional): specify -d to disable HTTP failover handling for agents connecting through a relay"
    Exit
}

pushd "$PSScriptRoot"

$ANT_HOME="$PSScriptRoot\opt\apache-ant-1.8.4"
$GROOVY_HOME="$PSScriptRoot\opt\groovy-1.8.8"
$JRE_ARCHIVE="ibm-java-jre-71-win-x86_64.zip"
$JRE="ibm-java-jre-71-win-x86_64"
$JAVA_HOME="$env:systemdrive\$JRE\jre"

echo "------------PSScriptRoot = $PSScriptRoot------------"
echo "------------env:TEMP =  $env:TEMP------------"
echo "------------env:systemdrive = $env:systemdrive------------"

mkdir $env:systemdrive\$JRE
$AGENT_INSTALL_BASEDIR="$env:systemdrive\opt\ibm-ucd"

$PROXY_PORT=20080
$INITIAL_TEAM="System Team"
$UCD_Agent_Properties_File="$PSScriptRoot\agent.install.properties"

# extract domain name from URL
echo "UCD Remote Host URL = $UCD_REMOTE_HOST"
$UCD_REMOTE_HOST=([System.Uri]$UCD_REMOTE_HOST).Host -replace '^www\.'
echo "Updated - UCD Remote Hostname = $UCD_REMOTE_HOST"

# Validate variable values
If ($UCD_AGENT_NAME -eq "") {
  echo "ERROR: UCD_AGENT_NAME not defined; exiting"
  Exit
} Else {
  echo "UCD_AGENT_NAME = $UCD_AGENT_NAME"
  If ($UCD_REMOTE_HOST -eq "") {
    echo "ERROR: UCD remote host not defined or malformed - please enter a URL for the UCD server, i.e. http://my.ucdserver.com; exiting"
    Exit
  }
  echo "Connecting to UrbanCode Deploy at '$UCD_REMOTE_HOST'"
}

# Append IP address to agent name
#$ETH0_IP=Get-NetIPAddress AddressFamily IPv4
$ipconf = ipconfig
$ipconf = $ipconf -match "IPv4"
$ipconf = $ipconf.split(":")[1].trim()
$ETH0_IP = $ipconf
$UCD_AGENT_NAME="$UCD_AGENT_NAME.$ETH0_IP"
echo "Updated - UCD_AGENT_NAME = $UCD_AGENT_NAME"

# Extract embedded java jre
echo "Extracting JRE to install dir...."
Expand-ZipFile -File "$PSScriptRoot\lib\jre\$JRE_ARCHIVE" -Destination "$env:systemdrive\$JRE"
echo "Completed extract of JRE"

# Set JAVA_HOME Environment variable needed for Groovy execution
$env:JAVA_HOME = $JAVA_HOME

# Call groovy script to write these to a install.properties file
If ($USE_RELAY -eq $true) {
  echo "Configuring agent for agent relay!"
  If ($PROXY_HOST -ne "" ) {
    $PROXY_HOST=$UCD_REMOTE_HOST
  }

  If ($UCD_PORT -ne "") {
    $UCD_PORT=7916
  }

  echo "Relay proxy host = $PROXY_HOST"
  echo "Relay proxy port = $PROXY_PORT"
  echo "UCD communication port = $UCD_PORT"

  $args = @()
  $args += ("`"$PSScriptRoot\install\template-install-agent.groovy`"")
  $args += ("`"$UCD_AGENT_NAME`"")
  $args += ("$UCD_REMOTE_HOST")
  $args += ("$UCD_PORT")
  $args += ("`"$JAVA_HOME`"")
  $args += ("`"$INITIAL_TEAM`"")
  $args += ("$PROXY_HOST")
  $args += ("$PROXY_PORT")
  $args += ("$DISABLE_HTTP_FAILOVER")

  $cmd = "`"$GROOVY_HOME\bin\groovy.bat`""

  Invoke-Expression "& $cmd $args"
} Else {
  If ($UCD_PORT -ne "") {
    $UCD_PORT=7918
  }

  echo "UCD communication port = $UCD_PORT"

  $args = @()
  $args += ("`"$PSScriptRoot\install\template-install-agent.groovy`"")
  $args += ("`"$UCD_AGENT_NAME`"")
  $args += ("$UCD_REMOTE_HOST")
  $args += ("$UCD_PORT")
  $args += ("`"$JAVA_HOME`"")
  $args += ("`"$INITIAL_TEAM`"")

  $cmd = "`"$GROOVY_HOME\bin\groovy.bat`""

  Invoke-Expression "& $cmd $args"
}

# Set replacement JAVA HOME for agent execution
$AGENT_INSTALL_DIR="$AGENT_INSTALL_BASEDIR\$UCD_AGENT_NAME"
$AGENT_JAVA_HOME="$env:systemdrive\$JRE\jre"
echo "Agent JAVA_HOME = $AGENT_JAVA_HOME"

# Set ANT_HOME Environment variable needed for ANT execution
$env:ANT_HOME = $ANT_HOME

cmd /C $PSScriptRoot\opt\apache-ant-1.8.4\bin\ant.bat -f "$PSScriptRoot\install.with.groovy.xml" `
     "-nouserlib" `
     "-noclasspath" `
     "-Dinstall-agent=true" `
     "-Dinstall.properties.file=`"$UCD_Agent_Properties_File`"" `
     install-non-interactive

# Run the installation.
# $args = @()
# $args += ("-f", "`"$PSScriptRoot\install.with.groovy.xml`"")
# $args += ("-nouserlib")
# $args += ("-noclasspath")
# $args += ("-Dinstall-agent=true")
# $args += ("-Dinstall.properties.file=`"$UCD_Agent_Properties_File`"")
# $args += ("-Dpackage.replacement.java.home=`"$AGENT_JAVA_HOME`"")
# $args += ("install-non-interactive")

# $cmd = "`"$ANT_HOME\bin\ant.bat`""

# echo "args: $args"
# echo "cmd: $cmd"

# Invoke-Expression "& $cmd $args"

# Copy JRE into agent directory
Copy-Item "$env:systemdrive\$JRE" -Destination "$AGENT_INSTALL_DIR\opt" -Recurse


# Start the agent if specified
If ($START_OPTION -eq "") {
  echo "Agent installed, not starting"
}
ElseIf ($START_OPTION -eq "install-service") {
	gsv -display "IBM UrbanCode Deploy Agent (udagent)"

}Else {
  echo "Starting agent with start option $START_OPTION"

  $args = @()
  $args += ("$START_OPTION")
  $cmd = "`"$AGENT_INSTALL_DIR\bin\agent.cmd`""
  Invoke-Expression "& $cmd $args"
}

popd
