/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Build
* IBM UrbanCode Deploy
* IBM UrbanCode Release
* IBM AnthillPro
* (c) Copyright IBM Corporation 2002, 2013. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/
import com.urbancode.air.AirPluginTool
import com.urbancode.air.CommandHelper

import com.amazonaws.AmazonServiceException;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.services.ec2.AmazonEC2;
import com.amazonaws.services.ec2.AmazonEC2Client;

import com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancing;
import com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient;
import com.amazonaws.services.elasticloadbalancing.model.ConfigureHealthCheckRequest;
import com.amazonaws.services.elasticloadbalancing.model.ConfigureHealthCheckResult;
import com.amazonaws.services.elasticloadbalancing.model.CreateAppCookieStickinessPolicyRequest;
import com.amazonaws.services.elasticloadbalancing.model.CreateLBCookieStickinessPolicyRequest;
import com.amazonaws.services.elasticloadbalancing.model.CreateLoadBalancerRequest;
import com.amazonaws.services.elasticloadbalancing.model.CreateLoadBalancerResult;
import com.amazonaws.services.elasticloadbalancing.model.DeregisterInstancesFromLoadBalancerRequest;
import com.amazonaws.services.elasticloadbalancing.model.DeregisterInstancesFromLoadBalancerResult;
import com.amazonaws.services.elasticloadbalancing.model.HealthCheck;
import com.amazonaws.services.elasticloadbalancing.model.Listener;
import com.amazonaws.services.elasticloadbalancing.model.RegisterInstancesWithLoadBalancerRequest;
import com.amazonaws.services.elasticloadbalancing.model.RegisterInstancesWithLoadBalancerResult;
import com.amazonaws.services.elasticloadbalancing.model.Instance;

def ch = new CommandHelper(new File('.'));
def apTool = new AirPluginTool(this.args[0], this.args[1]);
def props = apTool.getStepProperties();

def accessKeyId = props['accessKeyId'];
def secretKey = props['secretKey'];
def instanceIds = props['instanceIds'].split(',');
def loadBalancerName = props['loadBalancerName'];
def instances = [];


AWSCredentials creds = null;
creds = new BasicAWSCredentials(accessKeyId, secretKey);

AmazonElasticLoadBalancingClient elbClient = new AmazonElasticLoadBalancingClient(creds);


instanceIds.each { id ->
   instances << new Instance(id);
}

println "Registering instanceIds ${instanceIds} with load balancer ${loadBalancerName}";

RegisterInstancesWithLoadBalancerRequest request = new RegisterInstancesWithLoadBalancerRequest()
                                                      .withInstances(instances)
                                                      .withLoadBalancerName(loadBalancerName);

RegisterInstancesWithLoadBalancerResult result = elbClient.registerInstancesWithLoadBalancer(request);

def finalInstanceIds = result.getInstances().collect { return it.getInstanceId() };
println "Instances now registered with load balancer : " + 
        finalInstanceIds;


def notFound = [];
instanceIds.each { id ->
    if (! finalInstanceIds.contains(id)) {
        notFound << finalInstanceIds;
    }
}

if (!notFound.isEmpty()) {
    println "Some instances not registered:"
    notFound.each { id ->
       println id;
    }
    throw new Exception("Not all instances registered");
}
