/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Build
* IBM UrbanCode Deploy
* IBM UrbanCode Release
* IBM AnthillPro
* (c) Copyright IBM Corporation 2002, 2013. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/
import com.urbancode.air.AirPluginTool
import com.urbancode.air.CommandHelper

import com.urbancode.air.plugin.amazonec2.AmazonEC2Helper;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.services.ec2.AmazonEC2;
import com.amazonaws.services.ec2.AmazonEC2Client;


def ch = new CommandHelper(new File('.'));
def apTool = new AirPluginTool(this.args[0], this.args[1]);
def props = apTool.getStepProperties();

def accessKeyId = props['accessKeyId'];
def secretKey = props['secretKey'];
def status = props['status'];
def instanceIds = props['instances'].split(',');
def timeout = Long.valueOf(props['ec2Timeout']);

AWSCredentials creds = null;
creds = new BasicAWSCredentials(accessKeyId, secretKey);

AmazonEC2 ec2 = new AmazonEC2Client(creds);

new AmazonEC2Helper(apTool, ec2).waitForInstances(instanceIds, timeout, status)
