/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Build
* IBM UrbanCode Deploy
* IBM UrbanCode Release
* IBM AnthillPro
* (c) Copyright IBM Corporation 2002, 2013. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/
import com.urbancode.air.AirPluginTool
import com.urbancode.air.CommandHelper

import com.urbancode.air.plugin.amazonec2.AmazonEC2Helper;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.services.ec2.AmazonEC2;
import com.amazonaws.services.ec2.AmazonEC2Client;


def ch = new CommandHelper(new File('.'));
def apTool = new AirPluginTool(this.args[0], this.args[1]);
def props = apTool.getStepProperties();

def accessKeyId = props['accessKeyId'];
def secretKey = props['secretKey'];
def number = props['number'];
def ami = props['ami'];
def group = props['group'];
def zone = props['zone'];
def keyPair = props['keypair'];

def options = props['options'];
def instanceType = props['instanceType'];

AWSCredentials creds = null;
creds = new BasicAWSCredentials(accessKeyId, secretKey);

AmazonEC2 ec2 = new AmazonEC2Client(creds);

def helper = new AmazonEC2Helper(apTool, ec2);

def instanceIds = helper.startInstances(ami, number, instanceType, keyPair, zone, group, options)
apTool.setOutputProperties();

helper.waitForInstances(instanceIds, 600000, "running")
helper.gatherInstanceDetails(instanceIds)

apTool.setOutputProperties();
