/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Build
* IBM UrbanCode Deploy
* IBM UrbanCode Release
* IBM AnthillPro
* (c) Copyright IBM Corporation 2002, 2013. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/
import com.urbancode.air.AirPluginTool
import com.urbancode.air.CommandHelper

import com.amazonaws.AmazonServiceException;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.services.ec2.AmazonEC2;
import com.amazonaws.services.ec2.AmazonEC2Client;
import com.amazonaws.services.ec2.model.AuthorizeSecurityGroupIngressRequest;
import com.amazonaws.services.ec2.model.CreateSecurityGroupRequest;
import com.amazonaws.services.ec2.model.IpPermission;
import com.amazonaws.services.ec2.model.Reservation;
import com.amazonaws.services.ec2.model.Instance;
import com.amazonaws.services.ec2.model.AssociateAddressRequest;

def ch = new CommandHelper(new File('.'));
def apTool = new AirPluginTool(this.args[0], this.args[1]);
def props = apTool.getStepProperties();

def accessKeyId = props['accessKeyId'];
def secretKey = props['secretKey'];
def ips = props['ips'].split('\n');
def instances = props['instances'].split(',');



AWSCredentials creds = null;
creds = new BasicAWSCredentials(accessKeyId, secretKey);

AmazonEC2 ec2 = new AmazonEC2Client(creds);

for (int i=0; i < Math.min(ips.length, instances.length); i++) {
    println "Associating instance " + instances[i] + " with ip " + ips[i];
    AssociateAddressRequest req = new AssociateAddressRequest().withInstanceId(instances[i])
                                      .withPublicIp(ips[i]);
    ec2.associateAddress(req);
}
