/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.airplugins.test;

import com.urbancode.air.plugin_command.cli.PluginCommandRuntimeCli;
import com.urbancode.air.plugin_command.runtime.ShellHelper;
import com.urbancode.commons.util.IO;
import com.urbancode.commons.xml.DocumentBuilderFactoryBuilder;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.InputStream;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.junit.Assert;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TstHelper {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getVersionFromPluginZip(File pluginFile) throws Exception {
        String version = null;
        FileInputStream inStream = null;
        ZipInputStream zipStream = null;
        try {
            inStream = new FileInputStream(pluginFile);
            zipStream = new ZipInputStream(inStream);
            ZipEntry entry = null;
            while ((entry = zipStream.getNextEntry()) != null && !entry.getName().equals("plugin.xml")) {
            }
            if (entry == null) {
                throw new RuntimeException("Could not find plugin.xml in plugin file!");
            }
            DocumentBuilderFactory dbFac = DocumentBuilderFactoryBuilder.newBuilder().newDocumentBuilderFactory();
            DocumentBuilder db = dbFac.newDocumentBuilder();
            Document doc = db.parse(zipStream);
            NodeList nl = doc.getElementsByTagName("identifier");
            if (nl.getLength() != 1) {
                throw new RuntimeException("Plugin.xml has more or less than one identifier tag!");
            }
            NamedNodeMap nnm = nl.item(0).getAttributes();
            if (nnm == null) {
                throw new RuntimeException("No attributes on the identifier tag!");
            }
            Node versionNode = nnm.getNamedItem("version");
            if (versionNode == null) {
                throw new RuntimeException("No version attribute on identifier tag!");
            }
            version = versionNode.getNodeValue();
        }
        finally {
            try {
                if (zipStream != null) {
                    zipStream.close();
                }
                if (inStream != null) {
                    ((InputStream)inStream).close();
                }
            }
            catch (Exception exception) {}
        }
        return version;
    }

    public static File findDevPlugin(File pluginBaseDir, FileFilter filter) throws Exception {
        return TstHelper.findPlugin(pluginBaseDir, filter, "dev");
    }

    public static File findProdPlugin(File pluginBaseDir, FileFilter filter) throws Exception {
        return TstHelper.findPlugin(pluginBaseDir, filter, "prod");
    }

    public static File findPlugin(File pluginBaseDir, FileFilter filter, String type) throws Exception {
        File pluginFile = null;
        File devPluginDir = new File(pluginBaseDir, type);
        if (!devPluginDir.exists()) {
            throw new RuntimeException("Could not find dev plugin directory " + devPluginDir.getCanonicalPath());
        }
        File[] pluginFileArray = devPluginDir.listFiles(filter);
        if (pluginFileArray.length == 0) {
            throw new RuntimeException("Could not find dev plugin zip in " + devPluginDir.getCanonicalPath());
        }
        pluginFile = new File(devPluginDir, pluginFileArray[0].getName());
        return pluginFile;
    }

    public static File findPlugin(File pluginBaseDir, FileFilter filter) throws Exception {
        File pluginFile = null;
        File devPluginDir = pluginBaseDir;
        if (!devPluginDir.exists()) {
            throw new RuntimeException("Could not find dev plugin directory " + devPluginDir.getCanonicalPath());
        }
        File[] pluginFileArray = devPluginDir.listFiles(filter);
        if (pluginFileArray.length == 0) {
            throw new RuntimeException("Could not find dev plugin zip in " + devPluginDir.getCanonicalPath());
        }
        pluginFile = new File(devPluginDir, pluginFileArray[0].getName());
        return pluginFile;
    }

    public static void lookAheadAssert(String toFind, BufferedReader reader) throws Exception {
        TstHelper.lookAheadAssert(toFind, reader, false);
    }

    public static void lookAheadAssert(String toFind, BufferedReader reader, boolean useEqualsOnly) throws Exception {
        String line = null;
        boolean found = false;
        int firstLine = -1;
        int lastLine = -1;
        String previousLine = null;
        if (reader instanceof LineNumberReader) {
            firstLine = ((LineNumberReader)reader).getLineNumber();
        }
        while (!found && (line = reader.readLine()) != null) {
            if (useEqualsOnly) {
                if (line.equals(toFind)) {
                    found = true;
                }
            } else if (line.matches(toFind) || line.equals(toFind)) {
                found = true;
            }
            previousLine = line;
        }
        if (reader instanceof LineNumberReader) {
            lastLine = ((LineNumberReader)reader).getLineNumber();
        }
        String msg = "Did not find line matching :" + toFind;
        if (firstLine != -1 || lastLine != -1) {
            msg = String.format("Checked lines %d through %d, last line=\"%s\", did not find line matching : %s", firstLine, lastLine, String.valueOf(previousLine), toFind);
        }
        Assert.assertTrue((String)msg, (boolean)found);
    }

    public static void lookAheadAssertFalse(String toFind, BufferedReader reader) throws Exception {
        TstHelper.lookAheadAssertFalse(toFind, reader, false);
    }

    public static void lookAheadAssertFalse(String toFind, BufferedReader reader, boolean useEqualsOnly) throws Exception {
        String line = null;
        boolean found = false;
        while (!found && (line = reader.readLine()) != null) {
            if (useEqualsOnly) {
                if (!line.equals(toFind)) continue;
                found = true;
                continue;
            }
            if (!line.matches(toFind) && !line.equals(toFind)) continue;
            found = true;
        }
        Assert.assertFalse((String)("Found line matching :" + toFind), (boolean)found);
    }

    public static void runner(Properties inProps, File inPropsFile, File pluginFile, String pluginId, String version, String stepName, File envPropsFile, File outPropsFile, File workDir, File outLogFile, File errLogFile, File cacheDir, BufferedReader reader) throws Exception {
        TstHelper.runner(inProps, new Properties(), inPropsFile, pluginFile, pluginId, version, stepName, envPropsFile, outPropsFile, workDir, outLogFile, errLogFile, cacheDir, reader);
    }

    public static void runner(Properties inProps, Properties envProps, File inPropsFile, File pluginFile, String pluginId, String version, String stepName, File envPropsFile, File outPropsFile, File workDir, File outLogFile, File errLogFile, File cacheDir, BufferedReader reader) throws Exception {
        ShellHelper.setInstance((ShellHelper)new ShellHelper(IO.utf8()));
        FileOutputStream out = new FileOutputStream(inPropsFile);
        inProps.store(out, null);
        ((OutputStream)out).close();
        if (System.getenv("GROOVY_HOME") == null || System.getenv("GROOVY_HOME").trim().equals("")) {
            envProps.setProperty("GROOVY_HOME", "/usr/share/groovy");
        } else {
            envProps.setProperty("GROOVY_HOME", System.getenv("GROOVY_HOME"));
        }
        System.out.println(System.getenv("GROOVY_HOME"));
        out = new FileOutputStream(envPropsFile);
        envProps.store(out, null);
        ((OutputStream)out).close();
        String[] commandArgs = new String[]{"-z", pluginFile.getPath(), "-p", pluginId, "-v", version, "-s", stepName, "-ip", inPropsFile.getPath(), "-ep", envPropsFile.getPath(), "-op", outPropsFile.getPath(), "-w", workDir.getPath(), "-ol", outLogFile.getPath(), "-el", errLogFile.getPath(), "-c", cacheDir.getPath()};
        PluginCommandRuntimeCli cli = new PluginCommandRuntimeCli(commandArgs);
        cli.run();
        reader = new BufferedReader(new FileReader(outLogFile));
        String line = null;
        while ((line = reader.readLine()) != null) {
            System.out.println(line);
        }
        reader.close();
    }
}

