/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Build
* IBM UrbanCode Deploy
* IBM UrbanCode Release
* IBM AnthillPro
* (c) Copyright IBM Corporation 2002, 2013. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/
import com.urbancode.air.AirPluginTool
import com.urbancode.air.CommandHelper

final def workDir = new File('.').canonicalFile
final def apTool = new AirPluginTool(this.args[0], this.args[1])
final def props = apTool.getStepProperties()
def path = props['path']?:'apachectl'
def winServiceName = props['winServiceName']

println "Executable path: $path"
println "Windows Service Name: $winServiceName"

try {
    if (System.properties['os.name'].toLowerCase().contains('windows')) {
        if(winServiceName) {
            println "Detected Windows OS, stopping Apache via $winServiceName Windows service"
            def cmdHelper = new CommandHelper(workDir)
            cmdHelper.runCommand("Stopping apache server", ['net', 'stop', winServiceName])
        }
        else {
            println "Invalid Windows service name specified: $winServiceName"
            System.exit 1
        }
    }
    else {
        println "Detected *nix OS, stopping Apache via apachectl"
        def cmdHelper = new CommandHelper(workDir)
        cmdHelper.runCommand("Stopping apache server", [path, 'stop'])
    }
}
catch (Exception e) {
    println "Error stopping Apache: ${e.message}"
    System.exit 1
}

System.exit 0