/*
* Licensed Materials - Property of IBM* and/or HCL**
* UrbanCode Deploy
* UrbanCode Build
* UrbanCode Release
* AnthillPro
* (c) Copyright IBM Corporation 2014, 2017. All Rights Reserved.
* (c) Copyright HCL Technologies Ltd. 2018. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*
* * Trademark of International Business Machines
* ** Trademark of HCL Technologies Limited
*/

import com.urbancode.air.AirPluginTool
import com.urbancode.air.plugin.artifactory.ArtifactoryHelper

// Get step properties
AirPluginTool apTool = new AirPluginTool(this.args[0], this.args[1])
Properties inProps = apTool.getStepProperties()

final def REPO_PATH_SEPARATOR = "/"

String url        = inProps['url'].trim()
String username   = inProps['username']
String password   = inProps['password']
String apiKey     = inProps['apiKey'].trim()
String repo       = inProps['repo'].trim()
String repoPath    = inProps['repoPath'].trim()
String classifier = inProps['classifier']?.trim()
String version    = inProps['version'].trim()
String extension  = inProps['extension'].trim()
boolean allowInsecure = Boolean.valueOf(inProps['allowInsecure'])
//remove trailing slashes from url
while (url.endsWith(REPO_PATH_SEPARATOR)) {
    url = url.substring(0, url.length() - 1)
}
//remove trailing slashes from artifacts
while (repoPath.endsWith(REPO_PATH_SEPARATOR)) {
    repoPath = repoPath.substring(0, repoPath.length() - 1)
}

final def workDir = new File('.').canonicalFile

String proxyHost = inProps['proxyHost']?.trim()
String proxyPort = inProps['proxyPort']?.trim()
String proxyPass = inProps['proxyPass']?.trim()
String proxyUser = inProps['proxyUser']?.trim()

ArtifactoryHelper aHelper = new ArtifactoryHelper(username, password, apiKey, allowInsecure, proxyHost, proxyPort, proxyPass, proxyUser)

int endIndex = repoPath.lastIndexOf('/')
String groupId = ''
String artifactId = ''
if (endIndex != -1) {
    groupId = repoPath.substring(0, endIndex)
    artifactId = repoPath.substring(endIndex + 1, repoPath.length())
}
else {
    println("[Error] Repo path '$repoPath' must use the form 'groupId/artifactId'")
    System.exit(1)
}

// build path to artifact of form http://localhost:8080/artifactory/repo/gro/up/id/artifactid/version/artifactId-version-classifier.extension
String artifactUrl = aHelper.getCombinedUrl(url, repo)
artifactUrl = aHelper.getCombinedUrl(artifactUrl, groupId.replace('.', '/'))
artifactUrl = aHelper.getCombinedUrl(artifactUrl, artifactId)
artifactUrl = aHelper.getCombinedUrl(artifactUrl, version)
if (classifier) {
    artifactUrl = aHelper.getCombinedUrl(artifactUrl, "${artifactId}-${version}-${classifier}.${extension}")
}
else {
    artifactUrl = aHelper.getCombinedUrl(artifactUrl, "${artifactId}-${version}.${extension}")
}
def retrieved = aHelper.download(artifactUrl, workDir)
if (!retrieved) {
    System.exit(1)
}