/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.util.dbprofiler;

import com.infradna.tool.bridge_method_injector.BridgeMethodsAdded;
import com.urbancode.commons.util.Check;
import com.urbancode.commons.util.dbprofiler.DbProfileCounter;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;

@BridgeMethodsAdded
class ProfilingStatement
implements Statement {
    private final Statement delegate;

    ProfilingStatement(Statement delegate) {
        this.delegate = Check.nonNull(delegate, "delegate");
    }

    public void addBatch(String sql) throws SQLException {
        this.delegate.addBatch(sql);
    }

    public void cancel() throws SQLException {
        this.delegate.cancel();
    }

    public void clearBatch() throws SQLException {
        this.delegate.clearBatch();
    }

    public void clearWarnings() throws SQLException {
        this.delegate.clearWarnings();
    }

    public void close() throws SQLException {
        this.delegate.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        boolean result;
        DbProfileCounter counter = this.startExecute();
        try {
            result = this.delegate.execute(sql, autoGeneratedKeys);
        }
        finally {
            counter.endExecute();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        boolean result;
        DbProfileCounter counter = this.startExecute();
        try {
            result = this.delegate.execute(sql, columnIndexes);
        }
        finally {
            counter.endExecute();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        boolean result;
        DbProfileCounter counter = this.startExecute();
        try {
            result = this.delegate.execute(sql, columnNames);
        }
        finally {
            counter.endExecute();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(String sql) throws SQLException {
        boolean result;
        DbProfileCounter counter = this.startExecute();
        try {
            result = this.delegate.execute(sql);
        }
        finally {
            counter.endExecute();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] executeBatch() throws SQLException {
        int[] result;
        DbProfileCounter counter = this.startExecute();
        try {
            result = this.delegate.executeBatch();
        }
        finally {
            counter.endExecute();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet executeQuery(String sql) throws SQLException {
        ResultSet result;
        DbProfileCounter counter = this.startExecute();
        try {
            result = this.delegate.executeQuery(sql);
        }
        finally {
            counter.endExecute();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        int result;
        DbProfileCounter counter = this.startExecute();
        try {
            result = this.delegate.executeUpdate(sql, autoGeneratedKeys);
        }
        finally {
            counter.endExecute();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        int result;
        DbProfileCounter counter = this.startExecute();
        try {
            result = this.delegate.executeUpdate(sql, columnIndexes);
        }
        finally {
            counter.endExecute();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        int result;
        DbProfileCounter counter = this.startExecute();
        try {
            result = this.delegate.executeUpdate(sql, columnNames);
        }
        finally {
            counter.endExecute();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int executeUpdate(String sql) throws SQLException {
        int result;
        DbProfileCounter counter = this.startExecute();
        try {
            result = this.delegate.executeUpdate(sql);
        }
        finally {
            counter.endExecute();
        }
        return result;
    }

    public Connection getConnection() throws SQLException {
        return this.delegate.getConnection();
    }

    public int getFetchDirection() throws SQLException {
        return this.delegate.getFetchDirection();
    }

    public int getFetchSize() throws SQLException {
        return this.delegate.getFetchSize();
    }

    public ResultSet getGeneratedKeys() throws SQLException {
        return this.delegate.getGeneratedKeys();
    }

    public int getMaxFieldSize() throws SQLException {
        return this.delegate.getMaxFieldSize();
    }

    public int getMaxRows() throws SQLException {
        return this.delegate.getMaxRows();
    }

    public boolean getMoreResults() throws SQLException {
        return this.delegate.getMoreResults();
    }

    public boolean getMoreResults(int current) throws SQLException {
        return this.delegate.getMoreResults(current);
    }

    public int getQueryTimeout() throws SQLException {
        return this.delegate.getQueryTimeout();
    }

    public ResultSet getResultSet() throws SQLException {
        return this.delegate.getResultSet();
    }

    public int getResultSetConcurrency() throws SQLException {
        return this.delegate.getResultSetConcurrency();
    }

    public int getResultSetHoldability() throws SQLException {
        return this.delegate.getResultSetHoldability();
    }

    public int getResultSetType() throws SQLException {
        return this.delegate.getResultSetType();
    }

    public int getUpdateCount() throws SQLException {
        return this.delegate.getUpdateCount();
    }

    public SQLWarning getWarnings() throws SQLException {
        return this.delegate.getWarnings();
    }

    public void setCursorName(String name) throws SQLException {
        this.delegate.setCursorName(name);
    }

    public void setEscapeProcessing(boolean enable) throws SQLException {
        this.delegate.setEscapeProcessing(enable);
    }

    public void setFetchDirection(int direction) throws SQLException {
        this.delegate.setFetchDirection(direction);
    }

    public void setFetchSize(int rows) throws SQLException {
        this.delegate.setFetchSize(rows);
    }

    public void setMaxFieldSize(int max) throws SQLException {
        this.delegate.setMaxFieldSize(max);
    }

    public void setMaxRows(int max) throws SQLException {
        this.delegate.setMaxRows(max);
    }

    public void setQueryTimeout(int seconds) throws SQLException {
        this.delegate.setQueryTimeout(seconds);
    }

    public Statement getDelegate() {
        return this.delegate;
    }

    private DbProfileCounter startExecute() {
        DbProfileCounter result = DbProfileCounter.getCounter();
        result.startExecute();
        return result;
    }
}

