/*
 * Licensed Materials - Property of IBM Corp.
 * IBM UrbanCode Deploy
 * (c) Copyright IBM Corporation 2014. All Rights Reserved.
 *
 * U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
 * GSA ADP Schedule Contract with IBM Corp.
 */

import javax.servlet.http.*

import com.urbancode.air.plugin.artifactory.ArtifactoryHelper
import com.urbancode.commons.httpcomponentsutil.HttpClientBuilder
import com.urbancode.commons.util.IO

def isEmpty(value) {
    return value == null || value.equals("")
}

final def workDir = new File('.').canonicalFile
final def props = new Properties();
final def inputPropsFile = new File(args[0]);
final def inputPropsStream = null;
try {
    inputPropsStream = new FileInputStream(inputPropsFile);
    props.load(inputPropsStream);
}
catch (IOException e) {
    throw new RuntimeException(e);
}

final def REPO_PATH_SEPARATOR = "/";

def repoName = props['repositoryName']
def artifacts = props['artifacts'].split('\n');
def username = props['username'];
def password = props['password'];
def checkHash = props['checkHash'];
def repoUrl = props['artifactoryUrl'];
while (repoUrl.endsWith(REPO_PATH_SEPARATOR)) {
    repoUrl = repoUrl.substring(0, repoUrl.length() - 1);
}

def exitVal = 0;
HttpClientBuilder builder = ArtifactoryHelper.getBuilder();
if (username) {
    builder.setPreemptiveAuthentication(true);
    builder.setUsername(username);
    builder.setPassword(password);
}

try {
    artifacts.each { artifact ->
        String[] attrs = artifact.split('/');
        String repoKey = "";
        for (int i = 0; i <= attrs.length - 2; ++i) {
            repoKey = repoKey + attrs[i] + REPO_PATH_SEPARATOR;
        }

        String packageName = attrs[attrs.length - 1];
        if (!(packageName =~ /(?i)\.nupkg$/)) {
            packageName = packageName + ".nupkg"
        }

        String artifactUri = repoUrl + REPO_PATH_SEPARATOR + '/api/storage/' + repoKey + packageName;
        File artifactFile = ArtifactoryHelper.downloadFileFromRepo(artifactUri, checkHash.toString());
        if (artifactFile == null) {
            throw new Exception("Failed to download artifact : " + artifact);
        }

        //copy the temp file to this directory with the file name
        File finalFile = new File(workDir, packageName);
        println "Moving downloaded artifact to : " + finalFile.getAbsolutePath() + "\n";
        IO.move(artifactFile, finalFile);
        artifactFile.delete();
    }
}
catch (Exception e) {
    e.printStackTrace();
    exitVal=1;
}
System.exit(exitVal);
