/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.fileutils.filelister;

import com.urbancode.commons.fileutils.filelister.PermissionReader;
import com.urbancode.commons.util.unix.Unix;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class UnixPermissionReader
extends PermissionReader {
    private static final Logger log = Logger.getLogger(UnixPermissionReader.class);
    private final Unix unix;

    UnixPermissionReader() {
        this(new Unix());
    }

    UnixPermissionReader(Unix unix) {
        if (unix == null) {
            throw new NullPointerException("unix");
        }
        this.unix = unix;
    }

    @Override
    Set<?> getPermissions(File file) throws IOException {
        Set<Object> permissions = Collections.emptySet();
        if (this.unix.isUnix()) {
            try {
                file = file.getCanonicalFile();
                permissions = Collections.singleton(this.unix.getPermissions(file));
            }
            catch (IOException e) {
                throw (IOException)new IOException("Unable to read permissions for " + file).initCause(e);
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("Skipping permissions reading for path" + file + ": not on unix"));
        }
        return permissions;
    }
}

