/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.util.weighted;

import com.urbancode.commons.util.weighted.WeightFunction;
import com.urbancode.commons.util.weighted.WeightedObject;
import com.urbancode.commons.util.weighted.WeightedObjectComparator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class Weighted {
    public <W extends Comparable<W>, T> void sort(List<T> list, WeightFunction<W, T> function) {
        this.sort(list, function, null);
    }

    public <W extends Comparable<W>, T> void sort(List<T> list, WeightFunction<W, T> function, Comparator<? super W> comparator) {
        if (list.size() > 1) {
            List<WeightedObject<W, T>> weighted = this.weight(list, function);
            Comparator<WeightedObject<? super W, T>> cmp = this.newWeightedObjectComparator(comparator);
            Collections.sort(weighted, cmp);
            this.replaceElements(list, this.unweight(weighted));
        }
    }

    protected <T> void replaceElements(List<? super T> list1, List<? extends T> list2) {
        ListIterator<T> i = list1.listIterator();
        Iterator<T> j = list2.iterator();
        while (i.hasNext() && j.hasNext()) {
            i.next();
            i.set(j.next());
        }
    }

    protected <W extends Comparable<W>, T> WeightedObject<W, T> weight(T object, WeightFunction<W, T> f) {
        return WeightedObject.weight(object, f);
    }

    protected <W extends Comparable<W>, T> List<WeightedObject<W, T>> weight(List<T> list, WeightFunction<W, T> f) {
        ArrayList<WeightedObject<W, T>> result = new ArrayList<WeightedObject<W, T>>();
        for (T t : list) {
            result.add(this.weight(t, f));
        }
        return result;
    }

    protected <W extends Comparable<W>, T> List<T> unweight(List<WeightedObject<W, T>> list) {
        ArrayList<T> result = new ArrayList<T>();
        for (WeightedObject<W, T> w : list) {
            result.add(w.getObject());
        }
        return result;
    }

    protected <W extends Comparable<W>, T> Comparator<WeightedObject<W, T>> newWeightedObjectComparator(Comparator<? super W> comparator) {
        return WeightedObjectComparator.create(comparator);
    }
}

