/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.securedata;

import com.urbancode.air.securedata.BadBase64DataException;
import com.urbancode.air.securedata.BadEnvelopeException;
import com.urbancode.air.securedata.Base64Codec;
import com.urbancode.air.securedata.JSONCodec;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Pattern;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public final class Envelope {
    private static final Charset utf8 = Charset.forName("UTF8");
    private static final Base64Codec base64Codec = new Base64Codec();
    private static final JSONCodec jsonCodec = new JSONCodec();
    private static final Pattern propNamePattern = Pattern.compile("[-_0-9a-zA-Z]+");
    private static final String ENV_IV = "env:iv";
    private static final String ENV_SUITE = "env:suite";
    private static final String ENV_TIMESTAMP = "env:timestamp";
    private static final String ENV_HMAC = "env:hmac";
    private static final String ENV_BODY = "env:body";
    private Header header;
    private byte[] hmac;
    private byte[] body;

    public static Envelope fromBytes(byte[] bytes) throws BadEnvelopeException {
        try {
            return Envelope.fromJSON(jsonCodec.decode(bytes));
        }
        catch (JSONException e) {
            throw new BadEnvelopeException(e);
        }
    }

    public static Envelope fromString(String string) throws BadEnvelopeException {
        try {
            return Envelope.fromJSON(new JSONObject(string));
        }
        catch (JSONException e) {
            throw new BadEnvelopeException(e);
        }
    }

    private static Envelope fromJSON(JSONObject json) throws BadEnvelopeException {
        try {
            Envelope envelope = new Envelope();
            envelope.header = Header.fromJSON(json);
            String hmac = json.optString(ENV_HMAC, null);
            if (hmac != null) {
                envelope.hmac = base64Codec.decodeFromString(hmac);
            }
            envelope.body = base64Codec.decodeFromString(json.getString(ENV_BODY));
            return envelope;
        }
        catch (BadBase64DataException e) {
            throw new BadEnvelopeException(e);
        }
        catch (JSONException e) {
            throw new BadEnvelopeException(e);
        }
    }

    private Envelope() {
        this.header = new Header();
    }

    public Envelope(byte[] body) {
        body.getClass();
        this.header = new Header();
        this.body = body;
    }

    public Header getHeader() {
        return this.header;
    }

    public byte[] getHMAC() {
        return this.hmac;
    }

    public void setHMAC(byte[] hmac) {
        this.hmac = hmac;
    }

    public byte[] getBody() {
        return this.body;
    }

    public void setBody(byte[] body) {
        body.getClass();
        this.body = body;
    }

    public byte[] toBytes() {
        return jsonCodec.encode(this.toJSON());
    }

    public String toString() {
        return this.toJSON().toString();
    }

    private JSONObject toJSON() {
        try {
            JSONObject obj = new JSONObject();
            this.header.toJSON(obj);
            if (this.hmac != null) {
                obj.put(ENV_HMAC, (Object)base64Codec.encodeToString(this.hmac));
            }
            obj.put(ENV_BODY, (Object)base64Codec.encodeToString(this.body));
            return obj;
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }

    public static final class Header {
        private long timestamp;
        private byte[] iv;
        private String suite;
        private Map<String, String> properties = new HashMap<String, String>();

        static Header fromJSON(JSONObject obj) throws BadEnvelopeException {
            try {
                String iv;
                Header header = new Header();
                Iterator names = obj.keys();
                while (names.hasNext()) {
                    String name = names.next().toString();
                    if (name.startsWith("env:")) continue;
                    String value = obj.getString(name);
                    Header.throwIfBadMessage(Header.validatePropertyName(name));
                    Header.throwIfBadMessage(Header.validatePropertyValue(value));
                    header.properties.put(name, value);
                }
                header.suite = obj.optString(Envelope.ENV_SUITE, null);
                String timestamp = obj.optString(Envelope.ENV_TIMESTAMP, null);
                if (timestamp != null) {
                    header.timestamp = Long.valueOf(timestamp);
                }
                if ((iv = obj.optString(Envelope.ENV_IV, null)) != null) {
                    header.iv = base64Codec.decodeFromString(iv);
                }
                return header;
            }
            catch (JSONException e) {
                throw new BadEnvelopeException(e);
            }
        }

        private static void throwIfIllegalArgument(String reason) {
            if (reason != null) {
                throw new IllegalArgumentException(reason);
            }
        }

        private static void throwIfBadMessage(String reason) throws BadEnvelopeException {
            if (reason != null) {
                throw new BadEnvelopeException(reason);
            }
        }

        private static String validatePropertyName(String name) {
            name.getClass();
            if (name.startsWith("env:")) {
                return "property name is reserved: " + name;
            }
            if (!propNamePattern.matcher(name).matches()) {
                return "property name has invalid syntax: " + name;
            }
            return null;
        }

        private static String validatePropertyValue(String value) {
            value.getClass();
            if (value.isEmpty()) {
                return "property value is blank";
            }
            if (!value.trim().equals(value)) {
                return "property value has leading or trailing whitespace";
            }
            return null;
        }

        private Header() {
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        public void setTimestamp(long timestamp) {
            this.timestamp = timestamp;
        }

        public String getCryptoSuite() {
            return this.suite;
        }

        public void setCryptoSuite(String suite) {
            this.suite = suite;
        }

        public byte[] getInitializationVector() {
            return this.iv;
        }

        public void setInitializationVector(byte[] iv) {
            this.iv = iv;
        }

        public String getProperty(String name) {
            Header.throwIfIllegalArgument(Header.validatePropertyName(name));
            return this.properties.get(name);
        }

        public void setProperty(String name, String value) {
            Header.throwIfIllegalArgument(Header.validatePropertyName(name));
            Header.throwIfIllegalArgument(Header.validatePropertyValue(value));
            this.properties.put(name, value);
        }

        public void removeProperty(String name) {
            Header.throwIfIllegalArgument(Header.validatePropertyName(name));
            this.properties.remove(name);
        }

        public void clearProperties() {
            this.properties.clear();
        }

        void toJSON(JSONObject obj) throws JSONException {
            for (Map.Entry<String, String> e : this.properties.entrySet()) {
                obj.put(e.getKey(), (Object)e.getValue());
            }
            if (this.suite != null) {
                obj.put(Envelope.ENV_SUITE, (Object)this.suite);
            }
            if (this.timestamp != 0L) {
                obj.put(Envelope.ENV_TIMESTAMP, (Object)String.valueOf(this.timestamp));
            }
            if (this.iv != null) {
                obj.put(Envelope.ENV_IV, (Object)base64Codec.encodeToString(this.iv));
            }
        }

        byte[] toBytesForMAC() {
            StringBuilder sb = new StringBuilder();
            ArrayList<String> names = new ArrayList<String>(this.properties.keySet());
            Collections.sort(names);
            for (String name : names) {
                sb.append("prop:");
                sb.append(name);
                sb.append("=");
                sb.append(this.properties.get(name));
                sb.append("\n");
            }
            if (this.suite != null) {
                sb.append(Envelope.ENV_SUITE);
                sb.append("=");
                sb.append(this.suite);
                sb.append("\n");
            }
            if (this.timestamp != 0L) {
                sb.append(Envelope.ENV_TIMESTAMP);
                sb.append("=");
                sb.append(this.timestamp);
                sb.append("\n");
            }
            if (this.iv != null) {
                sb.append(Envelope.ENV_IV);
                sb.append("=");
                sb.append(base64Codec.encodeToString(this.iv));
                sb.append("\n");
            }
            return sb.toString().getBytes(utf8);
        }
    }
}

