/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.fileutils.event;

import com.urbancode.commons.fileutils.event.FileObserver;
import java.util.concurrent.atomic.AtomicBoolean;

public class FileObserverThread
extends Thread {
    public static final long DEFAULT_SLEEP_INTERVAL = 30000L;
    public static final long MINIMUM_SLEEP_INTERVAL = 1000L;
    private FileObserver observer;
    private long sleepInterval = 30000L;
    private AtomicBoolean isShutdown = new AtomicBoolean(false);

    public FileObserverThread(FileObserver observer) {
        this(observer, 30000L);
    }

    public FileObserverThread(FileObserver observer, long sleepInterval) {
        this.observer = observer;
        this.setSleepInterval(sleepInterval);
        this.setDaemon(true);
    }

    public long getSleepInterval() {
        return this.sleepInterval;
    }

    public void setSleepInterval(long sleepInterval) {
        this.sleepInterval = sleepInterval < 1000L ? 1000L : sleepInterval;
    }

    public void shutdown() {
        this.isShutdown.set(true);
    }

    public boolean isShutdown() {
        return this.isShutdown.get();
    }

    public void run() {
        while (!this.isShutdown()) {
            this.observer.run();
            try {
                FileObserverThread.sleep(this.sleepInterval);
            }
            catch (InterruptedException interruptedException) {}
        }
    }
}

