/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.util;

import java.util.Collection;
import java.util.Map;

public final class Check {
    public static <T extends Map<?, ?>> T allKeysNonNull(T parameter) {
        Check.nonNull(parameter, "map");
        int i = 0;
        for (Map.Entry<?, ?> e : parameter.entrySet()) {
            Check.nonNullInternal(e, "map entry %d", i);
            Check.nonNullInternal(e.getKey(), "map entry key %d", i);
            ++i;
        }
        return parameter;
    }

    public static <T extends Map<?, ?>> T allKeysNonNull(T parameter, String parameterName) {
        if (parameterName != null) {
            Check.nonNull(parameter, parameterName);
            int i = 0;
            for (Map.Entry<?, ?> e : parameter.entrySet()) {
                Check.nonNullInternal(e, "map %s entry %d", parameterName, i);
                Check.nonNullInternal(e.getKey(), "map %s entry key %d", parameterName, i);
                ++i;
            }
        } else {
            Check.allKeysNonNull(parameter);
        }
        return parameter;
    }

    public static <T extends Collection<?>> T allNonNull(T parameter) {
        Check.nonNull(parameter, "collection");
        int i = 0;
        for (Object e : parameter) {
            Check.nonNullInternal(e, "collection element %d", i);
            ++i;
        }
        return parameter;
    }

    public static <T extends Map<?, ?>> T allNonNull(T parameter) {
        Check.nonNull(parameter, "map");
        int i = 0;
        for (Map.Entry<?, ?> e : parameter.entrySet()) {
            Check.nonNullInternal(e, "map entry %d", i);
            Check.nonNullInternal(e.getKey(), "map entry key %d", i);
            Check.nonNullInternal(e.getValue(), "map entry value %d", i);
            ++i;
        }
        return parameter;
    }

    public static <T extends Collection<?>> T allNonNull(T parameter, String parameterName) {
        if (parameterName != null) {
            Check.nonNull(parameter, parameterName);
            int i = 0;
            for (Object e : parameter) {
                Check.nonNullInternal(e, "collection %s element %d", parameterName, i);
                ++i;
            }
        } else {
            Check.allNonNull(parameter);
        }
        return parameter;
    }

    public static <T extends Map<?, ?>> T allNonNull(T parameter, String parameterName) {
        if (parameterName != null) {
            Check.nonNull(parameter, parameterName);
            int i = 0;
            for (Map.Entry<?, ?> e : parameter.entrySet()) {
                Check.nonNullInternal(e, "map %s entry %d", parameterName, i);
                Check.nonNullInternal(e.getKey(), "map %s entry key %d", parameterName, i);
                Check.nonNullInternal(e.getValue(), "map %s entry value %d", parameterName, i);
                ++i;
            }
        } else {
            Check.allNonNull(parameter);
        }
        return parameter;
    }

    public static <T> T[] allNonNull(T[] parameter) {
        Check.nonNull(parameter, "array");
        for (int i = 0; i < parameter.length; ++i) {
            Check.nonNullInternal(parameter[i], "array element %d", i);
        }
        return parameter;
    }

    public static <T> T[] allNonNull(T[] parameter, String parameterName) {
        if (parameterName != null) {
            Check.nonNull(parameter, parameterName);
            for (int i = 0; i < parameter.length; ++i) {
                Check.nonNullInternal(parameter[i], "array %s element %d", parameterName, i);
            }
        } else {
            Check.allNonNull(parameter);
        }
        return parameter;
    }

    public static <T extends Collection<?>> T allType(T parameter, Class<?> type) {
        Check.nonNull(parameter, "collection");
        Check.nonNull(type, "type");
        int i = 0;
        for (Object e : parameter) {
            Check.nonNullInternal(e, "collection element %d", i);
            Check.typeInternal(e, type, "collection element %d is not a %s", i, type.getName());
            ++i;
        }
        return parameter;
    }

    public static <T extends Collection<?>> T allType(T parameter, String parameterName, Class<?> type) {
        Check.nonNull(type, "type");
        if (parameterName != null) {
            Check.nonNull(parameter, parameterName);
            Check.nonNull(type, "type");
            int i = 0;
            for (Object e : parameter) {
                Check.nonNullInternal(e, "collection %s element %d", parameterName, i);
                Check.typeInternal(e, type, "collection %s element %d is not a %s", parameterName, i, type.getName());
                ++i;
            }
        } else {
            Check.allType(parameter, type);
        }
        return parameter;
    }

    public static <T extends Map<?, ?>> T allValuesNonNull(T parameter) {
        Check.nonNull(parameter, "map");
        int i = 0;
        for (Map.Entry<?, ?> e : parameter.entrySet()) {
            Check.nonNullInternal(e, "map entry %d", i);
            Check.nonNullInternal(e.getValue(), "map entry value %d", i);
            ++i;
        }
        return parameter;
    }

    public static <T extends Map<?, ?>> T allValuesNonNull(T parameter, String parameterName) {
        if (parameterName != null) {
            Check.nonNull(parameter, parameterName);
            int i = 0;
            for (Map.Entry<?, ?> e : parameter.entrySet()) {
                Check.nonNullInternal(e, "map %s entry %d", parameterName, i);
                Check.nonNullInternal(e.getValue(), "map %s entry value %d", parameterName, i);
                ++i;
            }
        } else {
            Check.allKeysNonNull(parameter);
        }
        return parameter;
    }

    public static int containerSize(int parameter) {
        return Check.nonNegativeInternal(parameter, "container size %d < 0", parameter);
    }

    public static int containerSize(int parameter, String parameterName) {
        if (parameterName != null) {
            Check.nonNegativeInternal(parameter, "container size %s value %d < 0", parameterName, parameter);
        } else {
            Check.containerSize(parameter);
        }
        return parameter;
    }

    public static int index(int containerSize, int parameter) {
        Check.containerSize(containerSize);
        if (parameter < 0) {
            Check.throwIndexOutOfBounds("index %d < 0", parameter);
        }
        if (parameter >= containerSize) {
            Check.throwIndexOutOfBounds("index %d >= container size %d", parameter, containerSize);
        }
        return parameter;
    }

    public static int index(int containerSize, int offset, int length, int parameter) {
        Check.containerSize(containerSize);
        Check.indexRange(containerSize, offset, length);
        if (parameter < offset) {
            Check.throwIndexOutOfBounds("index %d < offset %d", parameter, offset);
        }
        if (parameter >= offset + length) {
            Check.throwIndexOutOfBounds("index %d >= offset %d + length %d", parameter, offset, length);
        }
        return parameter;
    }

    public static int index(int containerSize, int offset, int length, int parameter, String parameterName) {
        if (parameterName != null) {
            Check.containerSize(containerSize);
            Check.indexRange(containerSize, offset, length);
            if (parameter < offset) {
                Check.throwIndexOutOfBounds("index %s value %d < offset %d", parameterName, parameter, offset);
            }
            if (parameter >= offset + length) {
                Check.throwIndexOutOfBounds("index %s value %d >= offset %d + length %d", parameterName, parameter, offset, length);
            }
        } else {
            Check.index(containerSize, offset, length, parameter);
        }
        return parameter;
    }

    public static int index(int containerSize, int parameter, String parameterName) {
        if (parameterName != null) {
            Check.containerSize(containerSize);
            if (parameter < 0) {
                Check.throwIllegalArgument("index %s value %d < 0", parameterName, parameter);
            }
            if (parameter >= containerSize) {
                Check.throwIndexOutOfBounds("index %s value %d >= container size %d", parameterName, parameter, containerSize);
            }
        } else {
            Check.index(containerSize, parameter);
        }
        return parameter;
    }

    public static void indexRange(int containerSize, int offset, int length) {
        if (containerSize < 0) {
            Check.throwIllegalArgument("container size < 0", new Object[0]);
        }
        if (offset < 0) {
            Check.throwIndexOutOfBounds("offset %d < 0", offset);
        }
        if (length < 0) {
            Check.throwIndexOutOfBounds("length %d < 0", offset);
        }
        if (offset > containerSize || length > containerSize - offset) {
            Check.throwIndexOutOfBounds("offset %d + length %d > container size %d", offset, length, containerSize);
        }
    }

    public static void indexRange(long containerSize, long offset, long length) {
        if (containerSize < 0L) {
            Check.throwIllegalArgument("container size < 0", new Object[0]);
        }
        if (offset < 0L) {
            Check.throwIndexOutOfBounds("offset %d < 0", offset);
        }
        if (length < 0L) {
            Check.throwIndexOutOfBounds("offset %d < 0", offset);
        }
        if (offset > containerSize || length > containerSize - offset) {
            Check.throwIndexOutOfBounds("offset %d + length %d > container size %d", offset, length, containerSize);
        }
    }

    public static int negative(int parameter) {
        if (parameter >= 0) {
            Check.throwIllegalArgument("value %d >= 0", parameter);
        }
        return parameter;
    }

    public static int negative(int parameter, String parameterName) {
        if (parameterName != null) {
            if (parameter >= 0) {
                Check.throwIllegalArgument("%s value %d >= 0", parameterName, parameter);
            }
        } else {
            Check.negative(parameter);
        }
        return parameter;
    }

    public static long negative(long parameter) {
        if (parameter >= 0L) {
            Check.throwIllegalArgument("value %d >= 0", parameter);
        }
        return parameter;
    }

    public static long negative(long parameter, String parameterName) {
        if (parameterName != null) {
            if (parameter >= 0L) {
                Check.throwIllegalArgument("%s value %d >= 0", parameterName, parameter);
            }
        } else {
            Check.negative(parameter);
        }
        return parameter;
    }

    public static <T extends CharSequence> T nonBlank(T parameter) {
        Check.nonNull(parameter, "charsequence");
        Check.nonEmpty(parameter, "charsequence");
        if (parameter.toString().trim().length() == 0) {
            Check.throwIllegalArgument("charsequence is blank", new Object[0]);
        }
        return parameter;
    }

    public static <T extends CharSequence> T nonBlank(T parameter, String parameterName) {
        if (parameterName != null) {
            Check.nonNull(parameter, parameterName);
            Check.nonEmpty(parameter, parameterName);
            if (parameter.toString().trim().length() == 0) {
                Check.throwIllegalArgument("charsequence %s is blank", parameterName);
            }
        } else {
            Check.nonBlank(parameter);
        }
        return parameter;
    }

    public static boolean[] nonEmpty(boolean[] parameter) {
        Check.nonNull(parameter, "array");
        if (parameter.length == 0) {
            Check.throwIllegalArgument("array is empty", new Object[0]);
        }
        return parameter;
    }

    public static boolean[] nonEmpty(boolean[] parameter, String parameterName) {
        if (parameterName != null) {
            Check.nonNull(parameter, parameterName);
            if (parameter.length == 0) {
                Check.throwIllegalArgument("array %s is empty", parameterName);
            }
        } else {
            Check.nonEmpty(parameter);
        }
        return parameter;
    }

    public static byte[] nonEmpty(byte[] parameter) {
        Check.nonNull(parameter, "array");
        if (parameter.length == 0) {
            Check.throwIllegalArgument("array is empty", new Object[0]);
        }
        return parameter;
    }

    public static byte[] nonEmpty(byte[] parameter, String parameterName) {
        if (parameterName != null) {
            Check.nonNull(parameter, parameterName);
            if (parameter.length == 0) {
                Check.throwIllegalArgument("array %s is empty", parameterName);
            }
        } else {
            Check.nonEmpty(parameter);
        }
        return parameter;
    }

    public static char[] nonEmpty(char[] parameter) {
        Check.nonNull(parameter, "array");
        if (parameter.length == 0) {
            Check.throwIllegalArgument("array is empty", new Object[0]);
        }
        return parameter;
    }

    public static char[] nonEmpty(char[] parameter, String parameterName) {
        if (parameterName != null) {
            Check.nonNull(parameter, parameterName);
            if (parameter.length == 0) {
                Check.throwIllegalArgument("array %s is empty", parameterName);
            }
        } else {
            Check.nonEmpty(parameter);
        }
        return parameter;
    }

    public static double[] nonEmpty(double[] parameter) {
        Check.nonNull(parameter, "array");
        if (parameter.length == 0) {
            Check.throwIllegalArgument("array is empty", new Object[0]);
        }
        return parameter;
    }

    public static double[] nonEmpty(double[] parameter, String parameterName) {
        if (parameterName != null) {
            Check.nonNull(parameter, parameterName);
            if (parameter.length == 0) {
                Check.throwIllegalArgument("array %s is empty", parameterName);
            }
        } else {
            Check.nonEmpty(parameter);
        }
        return parameter;
    }

    public static float[] nonEmpty(float[] parameter) {
        Check.nonNull(parameter, "array");
        if (parameter.length == 0) {
            Check.throwIllegalArgument("array is empty", new Object[0]);
        }
        return parameter;
    }

    public static float[] nonEmpty(float[] parameter, String parameterName) {
        if (parameterName != null) {
            Check.nonNull(parameter, parameterName);
            if (parameter.length == 0) {
                Check.throwIllegalArgument("array %s is empty", parameterName);
            }
        } else {
            Check.nonEmpty(parameter);
        }
        return parameter;
    }

    public static int[] nonEmpty(int[] parameter) {
        Check.nonNull(parameter, "array");
        if (parameter.length == 0) {
            Check.throwIllegalArgument("array is empty", new Object[0]);
        }
        return parameter;
    }

    public static int[] nonEmpty(int[] parameter, String parameterName) {
        if (parameterName != null) {
            Check.nonNull(parameter, parameterName);
            if (parameter.length == 0) {
                Check.throwIllegalArgument("array %s is empty", parameterName);
            }
        } else {
            Check.nonEmpty(parameter);
        }
        return parameter;
    }

    public static long[] nonEmpty(long[] parameter) {
        Check.nonNull(parameter, "array");
        if (parameter.length == 0) {
            Check.throwIllegalArgument("array is empty", new Object[0]);
        }
        return parameter;
    }

    public static long[] nonEmpty(long[] parameter, String parameterName) {
        if (parameterName != null) {
            Check.nonNull(parameter, parameterName);
            if (parameter.length == 0) {
                Check.throwIllegalArgument("array %s is empty", parameterName);
            }
        } else {
            Check.nonEmpty(parameter);
        }
        return parameter;
    }

    public static short[] nonEmpty(short[] parameter) {
        Check.nonNull(parameter, "array");
        if (parameter.length == 0) {
            Check.throwIllegalArgument("array is empty", new Object[0]);
        }
        return parameter;
    }

    public static short[] nonEmpty(short[] parameter, String parameterName) {
        if (parameterName != null) {
            Check.nonNull(parameter, parameterName);
            if (parameter.length == 0) {
                Check.throwIllegalArgument("array %s is empty", parameterName);
            }
        } else {
            Check.nonEmpty(parameter);
        }
        return parameter;
    }

    public static <T extends CharSequence> T nonEmpty(T parameter) {
        Check.nonNull(parameter, "charsequence");
        if (parameter.length() == 0) {
            Check.throwIllegalArgument("charsequence is empty", new Object[0]);
        }
        return parameter;
    }

    public static <T extends Collection<?>> T nonEmpty(T parameter) {
        Check.nonNull(parameter, "collection");
        if (parameter.isEmpty()) {
            Check.throwIllegalArgument("collection is empty", new Object[0]);
        }
        return parameter;
    }

    public static <T extends Map<?, ?>> T nonEmpty(T parameter) {
        Check.nonNull(parameter, "map");
        if (parameter.isEmpty()) {
            Check.throwIllegalArgument("map is empty", new Object[0]);
        }
        return parameter;
    }

    public static <T extends CharSequence> T nonEmpty(T parameter, String parameterName) {
        if (parameterName != null) {
            Check.nonNull(parameter, parameterName);
            if (parameter.length() == 0) {
                Check.throwIllegalArgument("charsequence %s is empty", parameterName);
            }
        } else {
            Check.nonEmpty(parameter);
        }
        return parameter;
    }

    public static <T extends Collection<?>> T nonEmpty(T parameter, String parameterName) {
        if (parameterName != null) {
            Check.nonNull(parameter, parameterName);
            if (parameter.isEmpty()) {
                Check.throwIllegalArgument("collection %s is empty", parameterName);
            }
        } else {
            Check.nonEmpty(parameter);
        }
        return parameter;
    }

    public static <T extends Map<?, ?>> T nonEmpty(T parameter, String parameterName) {
        if (parameterName != null) {
            Check.nonNull(parameter, parameterName);
            if (parameter.isEmpty()) {
                Check.throwIllegalArgument("map %s is empty", parameterName);
            }
        } else {
            Check.nonEmpty(parameter);
        }
        return parameter;
    }

    public static <T> T[] nonEmpty(T[] parameter) {
        Check.nonNull(parameter, "array");
        if (parameter.length == 0) {
            Check.throwIllegalArgument("array is empty", new Object[0]);
        }
        return parameter;
    }

    public static <T> T[] nonEmpty(T[] parameter, String parameterName) {
        if (parameterName != null) {
            Check.nonNull(parameter, parameterName);
            if (parameter.length == 0) {
                Check.throwIllegalArgument("array %s is empty", parameterName);
            }
        } else {
            Check.nonEmpty(parameter);
        }
        return parameter;
    }

    public static int nonNegative(int parameter) {
        if (parameter < 0) {
            Check.throwIllegalArgument("value %d < 0", parameter);
        }
        return parameter;
    }

    public static int nonNegative(int parameter, String parameterName) {
        if (parameterName != null) {
            if (parameter < 0) {
                Check.throwIllegalArgument("%s value %d < 0", parameterName, parameter);
            }
        } else {
            Check.nonNegative(parameter);
        }
        return parameter;
    }

    public static long nonNegative(long parameter) {
        if (parameter < 0L) {
            Check.throwIllegalArgument("value %d < 0", parameter);
        }
        return parameter;
    }

    public static long nonNegative(long parameter, String parameterName) {
        if (parameterName != null) {
            if (parameter < 0L) {
                Check.throwIllegalArgument("%s value %d < 0", parameterName, parameter);
            }
        } else {
            Check.nonNegative(parameter);
        }
        return parameter;
    }

    public static <T> T nonNull(T parameter) {
        parameter.getClass();
        return parameter;
    }

    public static <T> T nonNull(T parameter, String parameterName) {
        if (parameterName != null) {
            if (parameter == null) {
                throw new NullPointerException(parameterName);
            }
        } else {
            Check.nonNull(parameter);
        }
        return parameter;
    }

    public static int nonPositive(int parameter) {
        if (parameter > 0) {
            Check.throwIllegalArgument("value %d > 0", parameter);
        }
        return parameter;
    }

    public static int nonPositive(int parameter, String parameterName) {
        if (parameterName != null) {
            if (parameter > 0) {
                Check.throwIllegalArgument("%s value %d > 0", parameterName, parameter);
            }
        } else {
            Check.nonPositive(parameter);
        }
        return parameter;
    }

    public static long nonPositive(long parameter) {
        if (parameter > 0L) {
            Check.throwIllegalArgument("value %d > 0", parameter);
        }
        return parameter;
    }

    public static long nonPositive(long parameter, String parameterName) {
        if (parameterName != null) {
            if (parameter > 0L) {
                Check.throwIllegalArgument("%s value %d > 0", parameterName, parameter);
            }
        } else {
            Check.nonPositive(parameter);
        }
        return parameter;
    }

    public static int nonZero(int parameter) {
        if (parameter == 0) {
            Check.throwIllegalArgument("value %d == 0", parameter);
        }
        return parameter;
    }

    public static int nonZero(int parameter, String parameterName) {
        if (parameterName != null) {
            if (parameter == 0) {
                Check.throwIllegalArgument("%s value %d == 0", parameterName, parameter);
            }
        } else {
            Check.nonZero(parameter);
        }
        return parameter;
    }

    public static long nonZero(long parameter) {
        if (parameter == 0L) {
            Check.throwIllegalArgument("value %d == 0", parameter);
        }
        return parameter;
    }

    public static long nonZero(long parameter, String parameterName) {
        if (parameterName != null) {
            if (parameter == 0L) {
                Check.throwIllegalArgument("%s value %d == 0", parameterName, parameter);
            }
        } else {
            Check.nonZero(parameter);
        }
        return parameter;
    }

    public static int positive(int parameter) {
        if (parameter <= 0) {
            Check.throwIllegalArgument("value %d <= 0", parameter);
        }
        return parameter;
    }

    public static int positive(int parameter, String parameterName) {
        if (parameterName != null) {
            if (parameter <= 0) {
                Check.throwIllegalArgument("%s value %d <= 0", parameterName, parameter);
            }
        } else {
            Check.positive(parameter);
        }
        return parameter;
    }

    public static long positive(long parameter) {
        if (parameter <= 0L) {
            Check.throwIllegalArgument("value %d <= 0", parameter);
        }
        return parameter;
    }

    public static long positive(long parameter, String parameterName) {
        if (parameterName != null) {
            if (parameter <= 0L) {
                Check.throwIllegalArgument("%s value %d <= 0", parameterName, parameter);
            }
        } else {
            Check.positive(parameter);
        }
        return parameter;
    }

    public static <T> T type(T parameter, Class<?> type) {
        Check.nonNull(type, "type");
        Check.nonNull(parameter);
        return Check.typeInternal(parameter, type, "value %d is not a %s", parameter, type.getName());
    }

    public static <T> T type(T parameter, String parameterName, Class<?> type) {
        Check.nonNull(type, "type");
        Check.nonNull(parameter);
        if (parameterName != null) {
            Check.typeInternal(parameter, type, "%s value %d is not a %s", parameterName, parameter, type.getName());
        } else {
            Check.type(parameter, type);
        }
        return parameter;
    }

    private static int nonNegativeInternal(int value, String message, Object ... messageArguments) {
        if (value < 0) {
            Check.throwIllegalArgument(message, messageArguments);
        }
        return value;
    }

    private static <T> T nonNullInternal(T value, String message, Object ... messageArguments) {
        if (value == null) {
            throw new NullPointerException(String.format(message, messageArguments));
        }
        return value;
    }

    private static void throwIllegalArgument(String message, Object ... messageArguments) {
        throw new IllegalArgumentException(String.format(message, messageArguments));
    }

    private static void throwIndexOutOfBounds(String message, Object ... messageArguments) {
        throw new IndexOutOfBoundsException(String.format(message, messageArguments));
    }

    private static <T> T typeInternal(T value, Class<?> type, String message, Object ... messageArguments) {
        if (!type.isInstance(value)) {
            throw new ClassCastException(String.format(message, messageArguments));
        }
        return value;
    }

    private Check() {
        throw new UnsupportedOperationException();
    }
}

