/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.util.immutable;

import com.urbancode.commons.util.immutable.ISeq;

final class ArraySeq<T>
implements ISeq<T> {
    final T[] array;
    final int i;

    public static <T> ISeq<T> create(T[] array) {
        if (array == null || array.length == 0) {
            return null;
        }
        return new ArraySeq<T>(array, 0);
    }

    private ArraySeq(T[] array, int i) {
        this.array = array;
        this.i = i;
    }

    @Override
    public T first() {
        return this.array[this.i];
    }

    @Override
    public ISeq<T> next() {
        if (this.i + 1 < this.array.length) {
            return new ArraySeq<T>(this.array, this.i + 1);
        }
        return null;
    }
}

