/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.util.nonull;

import com.urbancode.commons.util.Check;
import com.urbancode.commons.util.immutable.IImmutableVector;
import com.urbancode.commons.util.nonull.NonNull;
import com.urbancode.commons.util.nonull.NonNullCollections;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.ListIterator;

final class NonNullImmutableVector<T>
implements IImmutableVector<T>,
Serializable,
NonNull {
    private static final long serialVersionUID = 1L;
    private final IImmutableVector<T> delegate;

    NonNullImmutableVector(IImmutableVector<T> delegate) {
        this.delegate = Check.nonNull(delegate, "delegate");
    }

    @Override
    public void add(int index, T element) {
        this.delegate.add(index, element);
    }

    @Override
    public boolean add(T o) {
        return this.delegate.add(o);
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        return this.delegate.addAll(c);
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> c) {
        return this.delegate.addAll(index, c);
    }

    @Override
    public void clear() {
        this.delegate.clear();
    }

    @Override
    public boolean contains(Object o) {
        return this.delegate.contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.delegate.containsAll(c);
    }

    @Override
    public boolean equals(Object o) {
        return this.delegate.equals(o);
    }

    public String toString() {
        return this.delegate.toString();
    }

    @Override
    public T get(int index) {
        return (T)this.delegate.get(index);
    }

    @Override
    public int hashCode() {
        return this.delegate.hashCode();
    }

    @Override
    public int indexOf(Object o) {
        return this.delegate.indexOf(o);
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public Iterator<T> iterator() {
        return this.delegate.iterator();
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.delegate.lastIndexOf(o);
    }

    @Override
    public ListIterator<T> listIterator() {
        return this.delegate.listIterator();
    }

    @Override
    public ListIterator<T> listIterator(int index) {
        return this.delegate.listIterator(index);
    }

    @Override
    public T peek() {
        return this.delegate.peek();
    }

    @Override
    public IImmutableVector<T> pop() {
        IImmutableVector<T> modified = this.delegate.pop();
        if (this.delegate != modified) {
            return NonNullCollections.nonNullImmutableVector(modified);
        }
        return this;
    }

    @Override
    public T remove(int index) {
        return (T)this.delegate.remove(index);
    }

    @Override
    public boolean remove(Object o) {
        return this.delegate.remove(o);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.delegate.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.delegate.retainAll(c);
    }

    @Override
    public T set(int index, T element) {
        return this.delegate.set(index, element);
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public IImmutableVector<T> subList(int fromIndex, int toIndex) {
        IImmutableVector<T> modified = this.delegate.subList(fromIndex, toIndex);
        if (this.delegate != modified) {
            return NonNullCollections.nonNullImmutableVector(modified);
        }
        return this;
    }

    @Override
    public Object[] toArray() {
        return this.delegate.toArray();
    }

    @Override
    public <E> E[] toArray(E[] a) {
        return this.delegate.toArray(a);
    }

    @Override
    public IImmutableVector<T> with(int i, T element) {
        Check.nonNull(element, "element");
        IImmutableVector<T> modified = this.delegate.with(i, element);
        if (this.delegate != modified) {
            return NonNullCollections.nonNullImmutableVector(modified);
        }
        return this;
    }

    @Override
    public IImmutableVector<T> with(T element) {
        Check.nonNull(element, "element");
        IImmutableVector<T> modified = this.delegate.with(element);
        if (this.delegate != modified) {
            return NonNullCollections.nonNullImmutableVector(modified);
        }
        return this;
    }
}

