/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.util.ssl;

import com.urbancode.commons.util.ssl.SSLSocketConfig;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.util.ArrayList;
import java.util.List;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;

class ConfigurableSSLServerSocketFactory
extends SSLServerSocketFactory {
    final SSLServerSocketFactory socketFactory;
    List<SSLSocketConfig> configurators = new ArrayList<SSLSocketConfig>();

    public ConfigurableSSLServerSocketFactory(SSLServerSocketFactory socketFactory) {
        this.socketFactory = socketFactory;
    }

    public synchronized void addSocketConfigurator(SSLSocketConfig config) {
        this.configurators.add(config);
    }

    protected synchronized void configure(SSLServerSocket socket) {
        for (SSLSocketConfig config : this.configurators) {
            config.configure(socket);
        }
    }

    @Override
    public String[] getDefaultCipherSuites() {
        return this.socketFactory.getDefaultCipherSuites();
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return this.socketFactory.getSupportedCipherSuites();
    }

    @Override
    public ServerSocket createServerSocket(int port) throws IOException {
        SSLServerSocket socket = (SSLServerSocket)this.socketFactory.createServerSocket(port);
        this.configure(socket);
        return socket;
    }

    @Override
    public ServerSocket createServerSocket(int port, int backlog) throws IOException {
        SSLServerSocket socket = (SSLServerSocket)this.socketFactory.createServerSocket(port, backlog);
        this.configure(socket);
        return socket;
    }

    @Override
    public ServerSocket createServerSocket(int port, int backlog, InetAddress ifAddress) throws IOException {
        SSLServerSocket socket = (SSLServerSocket)this.socketFactory.createServerSocket(port, backlog, ifAddress);
        this.configure(socket);
        return socket;
    }
}

