/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.ds.client;

import com.urbancode.commons.fileutils.filelister.FileLister;
import com.urbancode.commons.httpcomponentsutil.HttpClientBuilder;
import com.urbancode.commons.util.IO;
import com.urbancode.commons.util.StringUtil;
import com.urbancode.ds.client.ClientCommandOption;
import com.urbancode.ds.client.ClientConfiguration;
import com.urbancode.ds.client.JSONPrinter;
import com.urbancode.ds.client.ParsedCommandLine;
import com.urbancode.ds.client.ZipRequestEntity;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.URI;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.BufferedHttpEntity;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public class ClientCommand {
    private final ClientConfiguration config;
    private final String name;
    private final String[] aliases;
    private final String summary;
    private final String description;
    private final String httpMethod;
    private final String contentType;
    private final String url;
    private final List<ClientCommandOption> options = new ArrayList<ClientCommandOption>();
    private final JSONObject template;

    public ClientCommand(ClientConfiguration config, String name, String[] aliases, String summary, String description, String httpMethod, String contentType, String url, JSONObject template) {
        this.config = config;
        this.name = name;
        this.aliases = aliases;
        this.summary = summary;
        this.description = description;
        this.httpMethod = httpMethod;
        this.contentType = contentType;
        this.url = url;
        this.template = template;
    }

    public ClientConfiguration getConfig() {
        return this.config;
    }

    public String getName() {
        return this.name;
    }

    public String[] getAliases() {
        return this.aliases;
    }

    public String getSummary() {
        return this.summary;
    }

    public String getDescription() {
        return this.description;
    }

    public String getHttpMethod() {
        return this.httpMethod;
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getURL() {
        return this.url;
    }

    public JSONObject getTemplate() {
        return this.template;
    }

    public void addOption(ClientCommandOption option) {
        this.options.add(option);
    }

    public ClientCommandOption getOptionByName(String name) {
        for (ClientCommandOption option : this.options) {
            if (!name.equals(option.getName())) continue;
            return option;
        }
        return null;
    }

    public ClientCommandOption[] getOptions() {
        return this.options.toArray(new ClientCommandOption[this.options.size()]);
    }

    public int execute(ParsedCommandLine parsedCommandLine, PrintStream out, PrintStream err, FileLister lister) throws Exception {
        ZipRequestEntity entity = null;
        if (lister != null) {
            entity = new ZipRequestEntity(lister);
        }
        return this.execute(parsedCommandLine, out, err, entity);
    }

    public int execute(ParsedCommandLine parsedCommandLine, PrintStream out, PrintStream err, InputStream input) throws Exception {
        BufferedHttpEntity entity = null;
        if (input != null) {
            entity = new BufferedHttpEntity(new InputStreamEntity(input, -1L));
        }
        return this.execute(parsedCommandLine, out, err, entity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int execute(ParsedCommandLine parsedCommandLine, PrintStream out, PrintStream err, HttpEntity requestEntity) throws Exception {
        String baseURL = parsedCommandLine.getOptionValue(this.getConfig().getWebUrlOption());
        baseURL = baseURL + (baseURL.endsWith("/") ? "cli" : "/cli");
        String url = this.getURL(baseURL, parsedCommandLine);
        HttpClientBuilder builder = new HttpClientBuilder();
        builder.setTrustAllCerts(true);
        HttpRequestBase method = null;
        int responseCode = -1;
        if ("POST".equalsIgnoreCase(this.getHttpMethod())) {
            method = new HttpPost(url);
            if (requestEntity != null) {
                ((HttpEntityEnclosingRequestBase)method).setEntity(requestEntity);
            }
        } else if ("GET".equalsIgnoreCase(this.getHttpMethod())) {
            method = new HttpGet(url);
        } else if ("PUT".equalsIgnoreCase(this.getHttpMethod())) {
            method = new HttpPut(url);
            if (requestEntity != null) {
                ((HttpPut)method).setEntity(requestEntity);
            }
        } else if ("DELETE".equalsIgnoreCase(this.getHttpMethod())) {
            method = new HttpDelete(url);
        } else {
            throw new RuntimeException("Unexpected method type: " + this.getHttpMethod());
        }
        String authToken = parsedCommandLine.getOptionValue(this.getConfig().getAuthTokenOption());
        String username = parsedCommandLine.getOptionValue(this.getConfig().getUsernameOption());
        String password = parsedCommandLine.getOptionValue(this.getConfig().getPasswordOption());
        if (authToken == null && (username == null || password == null)) {
            throw new Exception("Invalid security options: Either " + this.getConfig().getAuthTokenOption().getName() + " or " + this.getConfig().getUsernameOption().getName() + " and " + this.getConfig().getPasswordOption().getName() + " must be defined.");
        }
        if (username != null && password != null) {
            builder.setUsername(username);
            builder.setPassword(password);
            builder.setPreemptiveAuthentication(true);
        } else if (authToken != null) {
            method.setHeader("Authorization-Token", authToken);
        }
        if (!StringUtil.isEmpty(this.getContentType())) {
            method.setHeader("Content-type", this.getContentType());
        }
        DefaultHttpClient client = builder.buildClient();
        try {
            responseCode = this.executeMethod(client, method, out, err);
        }
        finally {
            method.releaseConnection();
        }
        return responseCode;
    }

    protected String getURL(String baseURL, ParsedCommandLine parsedCommandLine) throws Exception {
        StringBuilder urlBuilder = new StringBuilder();
        if (baseURL.endsWith("/") && this.getURL().startsWith("/")) {
            urlBuilder.append(baseURL.substring(0, baseURL.length() - 1));
        } else {
            urlBuilder.append(baseURL);
        }
        boolean isProperty = false;
        for (String part : this.getURL().split("[{}]")) {
            if (isProperty) {
                ClientCommandOption option;
                int colonIndex = part.indexOf(58);
                if (colonIndex > 0) {
                    part = part.substring(0, colonIndex);
                }
                if ((option = this.getOptionByName(part)) == null) {
                    throw new Exception("Configuration for command '" + this.getName() + "' has a " + "improperly formatted URL '" + this.getURL() + "'. Property not found: " + part);
                }
                String value = parsedCommandLine.getOptionValue(option);
                if (value != null) {
                    urlBuilder.append(URLEncoder.encode(value, "UTF-8"));
                }
            } else {
                urlBuilder.append(part);
            }
            isProperty = !isProperty;
        }
        boolean firstQueryParam = true;
        for (ClientCommandOption option : this.options) {
            String value;
            if (!ClientCommandOption.ParamType.QUERY.equals((Object)option.getParamType()) || (value = parsedCommandLine.getOptionValue(option)) == null) continue;
            value = URLEncoder.encode(value, "UTF-8");
            String queryParam = option.getName() + "=" + value;
            queryParam = firstQueryParam ? "?" + queryParam : "&" + queryParam;
            urlBuilder.append(queryParam);
            firstQueryParam = false;
        }
        return urlBuilder.toString();
    }

    private boolean isGoodResponseCode(int responseCode) {
        return responseCode >= 200 && responseCode < 300;
    }

    private int executeMethod(HttpClient client, HttpRequestBase method, PrintStream out, PrintStream err) throws Exception {
        HttpResponse response = client.execute(method);
        int responseCode = response.getStatusLine().getStatusCode();
        HttpEntity entity = response.getEntity();
        String responseString = null;
        if (entity != null) {
            responseString = IO.readText(entity.getContent());
        }
        if (this.isGoodResponseCode(responseCode)) {
            if (responseString == null) {
                out.println("Operation succeeded.");
            } else {
                try {
                    JSONObject responseJsonObject = new JSONObject(responseString);
                    new JSONPrinter().print(responseJsonObject, out);
                }
                catch (JSONException e) {
                    try {
                        JSONArray responseJsonArray = new JSONArray(responseString);
                        new JSONPrinter().print(responseJsonArray, out);
                    }
                    catch (JSONException e2) {
                        out.print(responseString);
                    }
                }
                out.println();
            }
        } else if (responseCode == 302) {
            Header locationHeader = response.getFirstHeader("Location");
            method.setURI(URI.create(locationHeader.getValue()));
            responseCode = this.executeMethod(client, method, out, err);
        } else if (responseString == null) {
            err.println("Operation failed: " + responseCode);
        } else {
            err.println(responseString);
        }
        return responseCode;
    }
}

