/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.vfs.client;

import com.urbancode.commons.util.FileFilterToRegex;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PatternPathFilter {
    private final List<Pattern> includePatterns = new ArrayList<Pattern>();
    private final List<Pattern> excludePatterns = new ArrayList<Pattern>();

    public PatternPathFilter(String[] includePatterns, String[] excludePatterns) {
        Pattern pattern;
        if (includePatterns != null) {
            for (String includePattern : includePatterns) {
                includePattern = Normalizer.normalize(includePattern, Normalizer.Form.NFD);
                pattern = FileFilterToRegex.convert(includePattern, 128);
                this.includePatterns.add(pattern);
            }
        }
        if (excludePatterns != null) {
            for (String excludePattern : excludePatterns) {
                excludePattern = Normalizer.normalize(excludePattern, Normalizer.Form.NFD);
                pattern = FileFilterToRegex.convert(excludePattern, 128);
                this.excludePatterns.add(pattern);
            }
        }
    }

    public PatternPathFilter(List<String> includePatterns, List<String> excludePatterns) {
        this(includePatterns.toArray(new String[includePatterns.size()]), excludePatterns.toArray(new String[excludePatterns.size()]));
    }

    public boolean includes(String path) {
        boolean included = true;
        path = Normalizer.normalize(path, Normalizer.Form.NFD);
        if (!this.includePatterns.isEmpty()) {
            for (Pattern includePattern : this.includePatterns) {
                if (includePattern.matcher(path).matches()) continue;
                included = false;
                break;
            }
        }
        if (included && !this.excludePatterns.isEmpty()) {
            for (Pattern excludePattern : this.excludePatterns) {
                if (!excludePattern.matcher(path).matches()) continue;
                included = false;
                break;
            }
        }
        return included;
    }
}

