/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.util;

import com.infradna.tool.bridge_method_injector.BridgeMethodsAdded;
import java.util.regex.Pattern;

@BridgeMethodsAdded
public class FileFilterToRegex {
    public static boolean isMatchAll(String input) {
        return "**/*".equals(FileFilterToRegex.normalize(input));
    }

    public static Pattern convert(String input) {
        return FileFilterToRegex.convert(input, 0);
    }

    public static Pattern convert(String input, int flags) {
        input = FileFilterToRegex.normalize(input);
        StringBuilder result = new StringBuilder();
        StringBuilder tail = new StringBuilder();
        if ("**/*".equals(input)) {
            result.append(".*");
            input = "";
        }
        if (input.endsWith("/**/*")) {
            input = input.substring(0, input.length() - 5);
            tail.append("([\\\\/].*)?$");
        }
        if (input.indexOf("**/") != -1) {
            int i;
            int index = 0;
            while ((index = input.indexOf("**/")) != -1) {
                for (i = 0; i < index; ++i) {
                    result.append(FileFilterToRegex.interpetCharacter(input.charAt(i)));
                }
                result.append("([^\\\\/]*[\\\\/])*");
                input = input.substring(index + 3);
            }
            for (i = 0; i < input.length(); ++i) {
                result.append(FileFilterToRegex.interpetCharacter(input.charAt(i)));
            }
        } else {
            for (int i = 0; i < input.length(); ++i) {
                result.append(FileFilterToRegex.interpetCharacter(input.charAt(i)));
            }
        }
        result.append((CharSequence)tail);
        return Pattern.compile(result.toString(), flags);
    }

    private static String interpetCharacter(char c) {
        String result = null;
        result = c == '*' ? "[^\\\\/]*" : (c == '?' ? "[^\\\\/]" : (c == '\\' || c == '/' ? "[\\\\/]+" : (c == '{' || c == '}' || c == '(' || c == ')' || c == '[' || c == ']' || c == '|' || c == '+' || c == '-' || c == '^' || c == '&' || c == '.' || c == '$' ? "\\" + c : "" + c)));
        return result;
    }

    private static String normalize(String input) {
        if (input == null || input.trim().length() == 0) {
            return "";
        }
        String result = input.trim().replace('\\', '/');
        result = result.replaceAll("/+$", "");
        if ((result = result.replaceAll("^/+", "")).equals("**") || result.endsWith("/**")) {
            result = result + "/*";
        }
        return result;
    }
}

