/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.ds.client;

import java.io.PrintStream;
import java.util.Iterator;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public class JSONPrinter {
    public void print(JSONObject object, PrintStream out) throws JSONException {
        this.print(object, out, 0);
    }

    private void print(JSONObject object, PrintStream out, int indent) throws JSONException {
        out.println("{");
        ++indent;
        Iterator keys = object.keys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            Object value = object.get(key);
            this.indent(out, indent);
            out.print("\"" + key + "\": ");
            this.print(value, out, indent);
            if (keys.hasNext()) {
                out.print(",");
            }
            out.println();
        }
        this.indent(out, --indent);
        out.print("}");
    }

    public void print(JSONArray array, PrintStream out) throws JSONException {
        this.print(array, out, 0);
    }

    private void print(JSONArray array, PrintStream out, int indent) throws JSONException {
        out.println("[");
        ++indent;
        for (int i = 0; i < array.length(); ++i) {
            Object object = array.get(i);
            this.indent(out, indent);
            this.print(object, out, indent);
            if (i != array.length() - 1) {
                out.print(",");
                this.indent(out, indent);
            }
            out.println();
        }
        this.indent(out, --indent);
        out.print("]");
    }

    private void print(Object object, PrintStream out, int indent) throws JSONException {
        if (object instanceof String) {
            out.print("\"" + object + "\"");
        } else if (object instanceof JSONObject) {
            this.print((JSONObject)object, out, indent);
        } else if (object instanceof JSONArray) {
            this.print((JSONArray)object, out, indent);
        } else {
            out.print(object);
        }
    }

    private void indent(PrintStream out, int indent) {
        String indentString = "";
        for (int i = 0; i < indent * 2; ++i) {
            indentString = indentString + " ";
        }
        out.print(indentString);
    }
}

