/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.ds.client;

import com.urbancode.ds.client.ClientCommandFlag;
import com.urbancode.ds.client.ClientConfiguration;
import com.urbancode.ds.client.ParsedCommandLine;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CommandLineParser {
    ParsedCommandLine parse(String[] args, Map<String, String> envMap) throws Exception {
        String cmdName = null;
        String fileName = null;
        boolean readFromInputStream = false;
        HashMap<String, Set<String>> optMap = new HashMap<String, Set<String>>();
        ArrayList<String> flagList = new ArrayList<String>();
        for (int a = 0; a < args.length; ++a) {
            Set<String> values;
            String propValue;
            ClientCommandFlag flag;
            String propName;
            if (args[a].startsWith("--")) {
                propName = args[a].substring(2);
                flag = ClientConfiguration.getFlag(propName);
                if (flag != null) {
                    flagList.add(propName);
                    continue;
                }
                if (a + 1 >= args.length) {
                    throw new Exception("Option has no value: " + args[a]);
                }
                propValue = args[++a];
                values = (HashSet<String>)optMap.get(propName);
                if (values == null) {
                    values = new HashSet<String>();
                    optMap.put(propName, values);
                }
                values.add(propValue);
                continue;
            }
            if (args[a].startsWith("-")) {
                if (args[a].length() == 1) {
                    readFromInputStream = true;
                    continue;
                }
                propName = args[a].substring(1);
                flag = ClientConfiguration.getFlag(propName);
                if (flag != null) {
                    flagList.add(propName);
                    continue;
                }
                if (a + 1 >= args.length) {
                    throw new Exception("Option has no value: " + args[a]);
                }
                propValue = args[++a];
                values = (Set)optMap.get(propName);
                if (values == null) {
                    values = new HashSet();
                    optMap.put(propName, values);
                }
                values.add(propValue);
                continue;
            }
            if (cmdName != null && fileName != null) {
                throw new Exception("Illegal argument: " + args[a]);
            }
            if (cmdName != null) {
                fileName = args[a];
                continue;
            }
            cmdName = args[a];
        }
        return new ParsedCommandLine(cmdName, fileName, readFromInputStream, optMap, envMap, flagList);
    }
}

