/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.ud.client;

import com.urbancode.ud.client.UDRestClient;
import java.io.IOException;
import java.net.URI;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.entity.StringEntity;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceClient
extends UDRestClient {
    public ResourceClient(URI url, String clientUser, String clientPassword) {
        super(url, clientUser, clientPassword);
    }

    public void addResourceToTeam(String resource, String team, String type) throws IOException {
        String uri = this.url + "/cli/resource/teams?team=" + this.encodePath(team) + "&type=" + this.encodePath(type) + "&resource=" + this.encodePath(resource);
        HttpPut method = new HttpPut(uri);
        this.invokeMethod(method);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRoleOnResource(String resource, String role, Map<String, String> properties) throws IOException, JSONException {
        String uri = this.url + "/rest/resource/resource/" + this.encodePath(resource) + "/role/" + this.encodePath(role);
        JSONObject propertiesObject = new JSONObject();
        for (Map.Entry<String, String> ent : properties.entrySet()) {
            propertiesObject.put(ent.getKey(), ent.getValue());
        }
        HttpPost method = new HttpPost(uri);
        try {
            StringEntity requestEntity = new StringEntity(propertiesObject.toString());
            method.setEntity(requestEntity);
            this.invokeMethod(method);
        }
        finally {
            this.releaseConnection(method);
        }
    }

    public String createResource(String name, String agentName, String agentPoolName, String parentName, String roleName) throws IOException, JSONException {
        String result = null;
        JSONObject jsonToSend = new JSONObject();
        jsonToSend.put("name", name);
        if (!StringUtils.isEmpty(parentName)) {
            jsonToSend.put("parent", parentName);
        }
        if (!StringUtils.isEmpty(roleName)) {
            jsonToSend.put("role", roleName);
        }
        if (!StringUtils.isEmpty(agentName)) {
            jsonToSend.put("agent", agentName);
        } else if (!StringUtils.isEmpty(agentPoolName)) {
            jsonToSend.put("agentPool", agentPoolName);
        }
        String uri = this.url + "/cli/resource/create";
        HttpPut method = new HttpPut(uri);
        StringEntity requestEntity = new StringEntity(jsonToSend.toString());
        method.setEntity(requestEntity);
        HttpResponse response = this.invokeMethod(method);
        result = this.getBody(response);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UUID createResourceRole(String roleName, String description) throws IOException, JSONException {
        UUID result;
        String uri = this.url + "/rest/resource/resourceRole";
        JSONObject resourceObject = new JSONObject();
        resourceObject.put("name", roleName);
        resourceObject.put("description", description);
        HttpPost method = new HttpPost(uri);
        try {
            StringEntity requestEntity = new StringEntity(resourceObject.toString());
            method.setEntity(requestEntity);
            HttpResponse response = this.invokeMethod(method);
            String body = this.getBody(response);
            result = UUID.fromString(new JSONObject(body).getString("id"));
        }
        finally {
            this.releaseConnection(method);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UUID createSubResource(UUID parentId, String resourceName, String description) throws IOException, JSONException {
        UUID result;
        String uri = this.url + "/rest/resource/resource";
        JSONObject resourceObject = new JSONObject();
        resourceObject.put("name", resourceName);
        resourceObject.put("parentId", parentId);
        resourceObject.put("description", description);
        HttpPut method = new HttpPut(uri);
        try {
            StringEntity requestEntity = new StringEntity(resourceObject.toString());
            method.setEntity(requestEntity);
            HttpResponse response = this.invokeMethod(method);
            String body = this.getBody(response);
            result = UUID.fromString(new JSONObject(body).getString("id"));
        }
        finally {
            this.releaseConnection(method);
        }
        return result;
    }

    public void deleteResource(String name) throws IOException {
        String uri = this.url + "/cli/resource/deleteResource?resource=" + this.encodePath(name);
        HttpDelete method = new HttpDelete(uri);
        HttpResponse response = this.invokeMethod(method);
        this.discardBody(response);
    }

    public void deleteResourceInventoryForComponent(String resourceName, String componentName, String version, String inventoryStatus) throws IOException {
        String uri = this.url + "/rest/inventory/resourceInventoryForComponent/?resource=" + this.encodePath(resourceName) + "&component=" + this.encodePath(componentName) + "&version=" + this.encodePath(version) + "&status=" + this.encodePath(inventoryStatus);
        HttpDelete method = new HttpDelete(uri);
        HttpResponse response = this.invokeMethod(method);
        this.discardBody(response);
    }

    public JSONObject getLatestVersionByResourceAndComponent(String resourceId, String componentId) throws Exception {
        JSONObject result = new JSONObject();
        String uri = this.url + "/rest/inventory/versionByResourceAndComponent/" + this.encodePath(resourceId) + "/" + this.encodePath(componentId);
        HttpGet method = new HttpGet(uri);
        HttpResponse response = this.invokeMethod(method);
        String body = this.getBody(response);
        result = new JSONObject(body);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONObject getResourceByPath(String path) throws IOException, JSONException {
        JSONObject result = null;
        String uri = this.url + "/rest/resource/resource/" + this.encodePath(path);
        HttpGet method = new HttpGet(uri);
        try {
            HttpResponse response = this.invokeMethod(method);
            String body = this.getBody(response);
            result = new JSONObject(body);
        }
        finally {
            this.releaseConnection(method);
        }
        return result;
    }

    public JSONObject getResourceById(String id) throws IOException, JSONException {
        JSONObject result = null;
        String uri = this.url + "/rest/resource/resource/" + this.encodePath(id);
        HttpGet method = new HttpGet(uri);
        HttpResponse response = this.invokeMethod(method);
        String body = this.getBody(response);
        result = new JSONObject(body);
        return result;
    }

    public String getResourceProperty(String resourceName, String name) throws IOException {
        if ("".equals(resourceName) || "".equals(name)) {
            throw new IOException("a required argument was not supplied");
        }
        String uri = this.url + "/cli/resource/getProperty?resource=" + this.encodePath(resourceName) + "&name=" + this.encodePath(name);
        HttpGet method = new HttpGet(uri);
        HttpResponse response = this.invokeMethod(method);
        String result = this.getBody(response);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONObject getResourceRoleByName(String name) throws IOException, JSONException {
        JSONObject result = null;
        String uri = this.url + "/rest/resource/resourceRole/" + this.encodePath(name);
        HttpGet method = new HttpGet(uri);
        try {
            HttpResponse response = this.invokeMethod(method);
            String body = this.getBody(response);
            result = new JSONObject(body);
        }
        finally {
            this.releaseConnection(method);
        }
        return result;
    }

    public JSONArray getResourceRoleProperties(String roleName, String resourceName) throws IOException, JSONException {
        if ("".equals(roleName) || "".equals(resourceName)) {
            throw new IOException("a required argument was not supplied");
        }
        String uri = this.url + "/rest/resource/resource/" + this.encodePath(resourceName) + "/propertiesForRole/" + this.encodePath(roleName);
        HttpGet method = new HttpGet(uri);
        HttpResponse response = this.invokeMethod(method);
        JSONArray result = new JSONArray(this.getBody(response));
        return result;
    }

    public String getResourceRolePropertyForResource(String roleName, String resourceName, String name) throws IOException, JSONException {
        JSONArray currentProps = this.getResourceRoleProperties(roleName, resourceName);
        JSONObject propsJSON = this.convertPropArrayToKeyValuePairs(currentProps);
        return propsJSON.getString(name);
    }

    public JSONArray getResourceRoles(String resource) throws IOException, JSONException {
        JSONArray result = null;
        String uri = this.url + "/rest/resource/resource/" + this.encodePath(resource) + "/roles";
        HttpGet method = new HttpGet(uri);
        HttpResponse response = this.invokeMethod(method);
        String body = this.getBody(response);
        result = new JSONArray(body);
        return result;
    }

    public List<String> getResourceRolesAsStrings(String resource) throws IOException, JSONException {
        ArrayList<String> result = new ArrayList<String>();
        String uri = this.url + "/cli/resource/getRolesForResource?resource=" + this.encodePath(resource);
        HttpGet method = new HttpGet(uri);
        HttpResponse response = this.invokeMethod(method);
        String body = this.getBody(response);
        JSONArray resultAsJSON = new JSONArray(body);
        for (int i = 0; i < resultAsJSON.length(); ++i) {
            String roleName = (String)((JSONObject)resultAsJSON.get(i)).get("name");
            result.add(roleName);
        }
        return result;
    }

    public JSONArray getResourceTree() throws IOException, JSONException {
        JSONArray result = null;
        String uri = this.url + "/rest/resource/resource/tree";
        HttpGet method = new HttpGet(uri);
        HttpResponse response = this.invokeMethod(method);
        String body = this.getBody(response);
        result = new JSONArray(body);
        return result;
    }

    public void inactivateResource(String name) throws IOException {
        String uri = this.url + "/rest/resource/resource/" + this.encodePath(name) + "/inactivate";
        HttpPut method = new HttpPut(uri);
        HttpResponse response = this.invokeMethod(method);
        this.discardBody(response);
    }

    public void removeRoleFromResource(String resource, String role) throws IOException {
        String uri = this.url + "/cli/resource/removeRoleFromResource?resource=" + this.encodePath(resource) + "&role=" + this.encodePath(role);
        HttpDelete method = new HttpDelete(uri);
        this.invokeMethod(method);
    }

    public String setResourceProperty(String resourceName, String name, String value, boolean isSecure) throws IOException {
        if ("".equals(resourceName) || "".equals(name)) {
            throw new IOException("a required argument was not supplied");
        }
        String uri = this.url + "/cli/resource/setProperty?resource=" + this.encodePath(resourceName) + "&name=" + this.encodePath(name) + "&value=" + this.encodePath(value) + "&isSecure=" + this.encodePath(String.valueOf(isSecure));
        HttpPut method = new HttpPut(uri);
        this.invokeMethod(method);
        String result = isSecure ? name + "=****" : name + "=" + value;
        return result;
    }

    public String setResourceRoleProperty(String roleName, String resourceName, String name, String value) throws IOException, JSONException {
        if ("".equals(roleName) || "".equals(resourceName) || "".equals("name")) {
            throw new IOException("a required argument was not supplied");
        }
        String uri = this.url + "/rest/resource/resource/" + this.encodePath(resourceName) + "/savePropertiesForRole/" + this.encodePath(roleName);
        JSONArray currentProps = this.getResourceRoleProperties(roleName, resourceName);
        JSONObject jsonToSend = this.convertPropArrayToKeyValuePairs(currentProps);
        jsonToSend.put(name, value);
        HttpPut method = new HttpPut(uri);
        StringEntity requestEntity = new StringEntity(jsonToSend.toString());
        method.setEntity(requestEntity);
        this.invokeMethod(method);
        String result = name + "=" + value;
        return result;
    }

    public void waitForResourceCreation(String name) throws IOException, InterruptedException, RemoteException {
        String uri = this.url + "/cli/resource/info?resource=" + this.encodePath(name);
        HttpGet method = new HttpGet(uri);
        HttpResponse response = this.invokeMethod(method);
        int status = response.getStatusLine().getStatusCode();
        long pollInterval = 1000L;
        long timeoutInterval = 600000L;
        long start = System.currentTimeMillis();
        while (status == 404) {
            if (System.currentTimeMillis() - start > timeoutInterval) {
                throw new RemoteException("Timeout waiting for Resource Creation");
            }
            try {
                this.discardBody(response);
                Thread.sleep(pollInterval);
                response = this.invokeMethod(method);
            }
            catch (IOException e) {}
        }
        if (status != 200) {
            throw new IOException(String.format("%d %s\n%s", response.getStatusLine().getStatusCode(), response.getStatusLine().getReasonPhrase(), this.getBody(response)));
        }
    }
}

