/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.ud.client;

import com.urbancode.ds.client.AddVersionFilesCommand;
import com.urbancode.ud.client.ComponentClient;
import com.urbancode.ud.client.UDRestClient;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.UUID;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpPost;
import org.apache.log4j.Logger;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public class VersionClient
extends UDRestClient {
    private static final Logger log = Logger.getLogger(ComponentClient.class);

    public VersionClient(URI url, String clientUser, String clientPassword) {
        super(url, clientUser, clientPassword);
    }

    public UUID createVersion(String component, String version, String description) throws IOException, JSONException {
        UUID result = null;
        String uri = this.url + "/cli/version/createVersion/?name=" + this.encodePath(version) + "&component=" + this.encodePath(component) + "&description=" + this.encodePath(description);
        HttpPost method = new HttpPost(uri);
        HttpResponse response = this.invokeMethod(method);
        String body = this.getBody(response);
        JSONObject jsonResult = new JSONObject(body);
        result = UUID.fromString((String)jsonResult.get("id"));
        return result;
    }

    @Deprecated
    public void addVersionFiles(String component, String version, File base, String offset, String[] includes, String[] excludes, boolean saveExecuteBits, boolean verbose) throws Exception {
        AddVersionFilesCommand command = new AddVersionFilesCommand(this.url.toString(), this.client, component, version, base, offset, includes, excludes, saveExecuteBits, verbose);
        command.execute();
    }

    public void addVersionFiles(String component, String version, File base, String offset, String[] includes, String[] excludes, boolean saveExecuteBits, boolean verbose, Charset charset, String[] extensions) throws Exception {
        AddVersionFilesCommand command = new AddVersionFilesCommand(this.url.toString(), this.client, component, version, base, offset, includes, excludes, saveExecuteBits, verbose, charset, extensions);
        command.execute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteVersion(UUID versionId) throws IOException {
        String uri = this.url + "/rest/deploy/version/" + versionId.toString();
        HttpDelete method = new HttpDelete(uri);
        try {
            this.invokeMethod(method);
        }
        finally {
            this.releaseConnection(method);
        }
    }

    public UUID createAndAddVersionFiles(String component, String version, String description, File baseDir, String offset, String[] includes, String[] excludes, boolean saveExecuteBits, boolean verbose, Charset charset, String[] extensions) throws Exception {
        UUID versionId = this.createVersion(component, version, description);
        try {
            this.addVersionFiles(component, version, baseDir, offset, includes, excludes, saveExecuteBits, verbose, charset, extensions);
        }
        catch (Exception e) {
            log.error("Error creating version" + e.getMessage());
            log.error("Cleaning up version " + versionId);
            this.deleteVersion(versionId);
            throw e;
        }
        return versionId;
    }
}

