/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.httpcomponentsutil;

import com.urbancode.commons.httpcomponentsutil.PreemptiveAuthHttpClient;
import com.urbancode.commons.util.ssl.OpenX509TrustManager;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.client.DefaultRedirectStrategy;
import org.apache.http.impl.conn.PoolingClientConnectionManager;
import org.apache.http.impl.conn.SchemeRegistryFactory;
import org.apache.http.params.HttpParams;

public class HttpClientBuilder {
    boolean trustAllCerts = false;
    int timeoutMillis = -1;
    int timeoutRetry = 3;
    String username = null;
    String password = null;
    String proxyHost = null;
    int proxyPort = -1;
    String proxyUsername = null;
    String proxyPassword = null;
    private boolean preemptiveAuthentication = false;
    ClientConnectionManager connectionManager = null;

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setTimeoutMillis(int timeoutMillis) {
        this.timeoutMillis = timeoutMillis;
    }

    public void setTimeoutRetry(int timeoutRetry) {
        this.timeoutRetry = timeoutRetry;
    }

    public void setTrustAllCerts(boolean trustAllCerts) {
        this.trustAllCerts = trustAllCerts;
    }

    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    public void setProxyPort(int proxyPort) {
        this.proxyPort = proxyPort;
    }

    public void setProxyUsername(String proxyUsername) {
        this.proxyUsername = proxyUsername;
    }

    public void setProxyPassword(String proxyPassword) {
        this.proxyPassword = proxyPassword;
    }

    public void setConnectionManager(ClientConnectionManager connectionManager) {
        this.connectionManager = connectionManager;
    }

    public void setPreemptiveAuthentication(boolean preemptiveAuthentication) {
        this.preemptiveAuthentication = preemptiveAuthentication;
    }

    public DefaultHttpClient buildClient() {
        ClientConnectionManager ccm;
        if (this.connectionManager == null) {
            SchemeRegistry schemeRegistry = SchemeRegistryFactory.createDefault();
            PoolingClientConnectionManager ccmPool = new PoolingClientConnectionManager(schemeRegistry);
            ccmPool.setDefaultMaxPerRoute(20);
            ccmPool.setMaxTotal(100);
            ccm = ccmPool;
        } else {
            ccm = this.connectionManager;
        }
        if (this.trustAllCerts) {
            Scheme openTlsScheme = this.buildOpenTLSScheme();
            ccm.getSchemeRegistry().register(openTlsScheme);
        }
        PreemptiveAuthHttpClient client = new PreemptiveAuthHttpClient(ccm);
        HttpParams params = client.getParams();
        CredentialsProvider credentialProvider = client.getCredentialsProvider();
        params.removeParameter("http.socket.buffer-size");
        if (this.timeoutMillis > 0) {
            params.setParameter("http.socket.timeout", this.timeoutMillis);
            params.setParameter("http.connection.timeout", this.timeoutMillis);
        }
        if (this.proxyHost != null && this.proxyHost.length() > 0) {
            HttpHost proxy = new HttpHost(this.proxyHost, this.proxyPort);
            params.setParameter("http.route.default-proxy", proxy);
            if (StringUtils.isNotEmpty(this.proxyUsername)) {
                UsernamePasswordCredentials proxyCredentials = new UsernamePasswordCredentials(this.proxyUsername, this.proxyPassword);
                AuthScope proxyScope = new AuthScope(this.proxyHost, this.proxyPort);
                credentialProvider.setCredentials(proxyScope, proxyCredentials);
            }
        }
        if (this.username != null && this.password != null) {
            UsernamePasswordCredentials clientCredentials = new UsernamePasswordCredentials(this.username, this.password);
            credentialProvider.setCredentials(AuthScope.ANY, clientCredentials);
            client.setPreemptiveAuthentication(this.preemptiveAuthentication);
        }
        client.setRedirectStrategy(new DefaultRedirectStrategy());
        return client;
    }

    private Scheme buildOpenTLSScheme() {
        SSLContext sslContext;
        try {
            sslContext = SSLContext.getInstance("SSL");
            sslContext.init(null, new TrustManager[]{new OpenX509TrustManager()}, null);
        }
        catch (KeyManagementException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        SSLSocketFactory factory = sslContext.getSocketFactory();
        org.apache.http.conn.ssl.SSLSocketFactory schemeSocketFactory = new org.apache.http.conn.ssl.SSLSocketFactory(factory, org.apache.http.conn.ssl.SSLSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
        Scheme scheme = new Scheme("https", 443, schemeSocketFactory);
        return scheme;
    }
}

