/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.ud.client;

import com.urbancode.commons.httpcomponentsutil.HttpClientBuilder;
import com.urbancode.commons.util.IO;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UDRestClient {
    private static final Logger log = Logger.getLogger(UDRestClient.class);
    protected final URI url;
    protected final String clientUser;
    protected final String clientPassword;
    protected final DefaultHttpClient client;

    public UDRestClient(URI url, String clientUser, String clientPassword) {
        this.url = url;
        this.clientUser = clientUser;
        this.clientPassword = clientPassword;
        HttpClientBuilder builder = new HttpClientBuilder();
        builder.setPreemptiveAuthentication(true);
        builder.setUsername(clientUser);
        builder.setPassword(clientPassword);
        builder.setTrustAllCerts(true);
        if (!StringUtils.isEmpty(System.getenv("PROXY_HOST")) && StringUtils.isNumeric(System.getenv("PROXY_PORT"))) {
            log.debug("Configuring proxy settings.");
            builder.setProxyHost(System.getenv("PROXY_HOST"));
            builder.setProxyPort(Integer.valueOf(System.getenv("PROXY_PORT")));
        }
        if (!StringUtils.isEmpty(System.getenv("PROXY_USERNAME")) && StringUtils.isNumeric(System.getenv("PROXY_PASSWORD"))) {
            log.debug("Configuring proxy settings.");
            builder.setProxyUsername(System.getenv("PROXY_USERNAME"));
            builder.setProxyPassword(System.getenv("PROXY_PASSWORD"));
        }
        this.client = builder.buildClient();
    }

    protected JSONObject createNewPropertyJSON(String name, String value, boolean isSecure) throws JSONException {
        JSONObject result = new JSONObject();
        result.put("name", name).put("value", value).put("secure", isSecure);
        return result;
    }

    protected JSONObject convertPropArrayToKeyValuePairs(JSONArray propArray) throws JSONException {
        JSONObject result = new JSONObject();
        for (int i = 0; i < propArray.length(); ++i) {
            JSONObject prop = propArray.getJSONObject(i);
            JSONObject propDefJSON = null;
            try {
                propDefJSON = (JSONObject)prop.get("propValue");
            }
            catch (JSONException e) {
                propDefJSON = (JSONObject)prop.get("propDef");
            }
            String propKey = (String)propDefJSON.get("name");
            String propValue = (String)propDefJSON.get("value");
            result.put(propKey, propValue);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getBody(HttpResponse response) throws IOException {
        StringBuilder builder = new StringBuilder();
        InputStream body = response.getEntity().getContent();
        if (body != null) {
            InputStreamReader reader = IO.reader(body, IO.utf8());
            try {
                IO.copy((Reader)reader, builder);
            }
            finally {
                ((Reader)reader).close();
            }
        }
        return builder.toString();
    }

    protected void discardBody(HttpResponse response) throws IOException {
        EntityUtils.consumeQuietly(response.getEntity());
    }

    protected HttpResponse invokeMethod(HttpRequestBase request) throws IOException, ClientProtocolException {
        HttpResponse response = this.client.execute(request);
        int status = response.getStatusLine().getStatusCode();
        if (status > 299) {
            throw new IOException(String.format("%d %s\n%s", response.getStatusLine().getStatusCode(), response.getStatusLine().getReasonPhrase(), this.getBody(response)));
        }
        return response;
    }

    protected void releaseConnection(HttpRequestBase request) {
        request.releaseConnection();
    }

    protected String encodePath(String path) {
        String result;
        try {
            result = this.sanitizePath(path);
        }
        catch (Exception e) {
            log.debug("the user input " + path + " could not be sanitized. defaulting to user input", e);
            result = path;
        }
        return result;
    }

    private String sanitizePath(String path) throws URISyntaxException {
        String result = "";
        String remainingPath = path;
        int dirtyChars = this.count(path, ':') + this.count(path, '&') + this.count(path, '+') + this.count(path, '/');
        for (int i = 0; i < dirtyChars; ++i) {
            int nextForwardSlash;
            int nextPlus;
            int nextAmpersand;
            int nextColon = remainingPath.indexOf(58);
            if (this.isIndexLeastAndValid(nextColon, nextAmpersand = remainingPath.indexOf(38), nextPlus = remainingPath.indexOf(43), nextForwardSlash = remainingPath.indexOf(47))) {
                result = result + this.encodeSubstring(remainingPath.substring(0, nextColon));
                result = result + "%3A";
                if (nextColon < remainingPath.length()) {
                    remainingPath = remainingPath.substring(nextColon + 1);
                    continue;
                }
                remainingPath = "";
                continue;
            }
            if (this.isIndexLeastAndValid(nextAmpersand, nextColon, nextPlus, nextForwardSlash)) {
                result = result + this.encodeSubstring(remainingPath.substring(0, nextAmpersand));
                result = result + "%26";
                if (nextAmpersand < remainingPath.length()) {
                    remainingPath = remainingPath.substring(nextAmpersand + 1);
                    continue;
                }
                remainingPath = "";
                continue;
            }
            if (this.isIndexLeastAndValid(nextPlus, nextColon, nextAmpersand, nextForwardSlash)) {
                result = result + this.encodeSubstring(remainingPath.substring(0, nextPlus));
                result = result + "%2B";
                if (nextPlus < remainingPath.length()) {
                    remainingPath = remainingPath.substring(nextPlus + 1);
                    continue;
                }
                remainingPath = "";
                continue;
            }
            if (!this.isIndexLeastAndValid(nextForwardSlash, nextPlus, nextColon, nextAmpersand)) continue;
            result = result + this.encodeSubstring(remainingPath.substring(0, nextForwardSlash));
            result = result + "%2F";
            remainingPath = nextPlus < remainingPath.length() ? remainingPath.substring(nextForwardSlash + 1) : "";
        }
        result = result + this.encodeSubstring(remainingPath);
        return result;
    }

    private boolean isIndexLeastAndValid(int indexToTest, int ... others) {
        boolean result = true;
        if (indexToTest >= 0) {
            for (int i = 0; i < others.length; ++i) {
                if (others[i] <= 0 || indexToTest <= others[i]) continue;
                result = false;
                break;
            }
        } else {
            result = false;
        }
        return result;
    }

    private int count(String fullString, char charToCount) {
        int result = 0;
        for (char charToTest : fullString.toCharArray()) {
            if (charToCount != charToTest) continue;
            ++result;
        }
        return result;
    }

    private String encodeSubstring(String toEncode) throws URISyntaxException {
        URI subUri = new URI(null, null, toEncode, null);
        return subUri.toASCIIString();
    }

    public Map<String, String> getJSONAsProperties(JSONObject object) {
        HashMap<String, String> result = new HashMap<String, String>();
        try {
            Iterator iterator = object.keys();
            while (iterator.hasNext()) {
                String key = (String)iterator.next();
                Object value = object.get(key);
                if (value instanceof JSONObject || value instanceof JSONArray) continue;
                result.put(key, String.valueOf(value));
            }
        }
        catch (JSONException e) {
            throw new RuntimeException("Failed to convert from JSON to map", e);
        }
        return result;
    }
}

