/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.util.query;

import com.infradna.tool.bridge_method_injector.BridgeMethodsAdded;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@BridgeMethodsAdded
public abstract class QueryFilter {
    private int rowsPerPage = Integer.MAX_VALUE;
    private int pageNumber = 1;
    private boolean isDescending = false;
    private String orderField = null;
    private List<Filter> filters = new ArrayList<Filter>();

    public QueryFilter() {
    }

    public QueryFilter(QueryFilter prototype) {
        this.rowsPerPage = prototype.getRowsPerPage();
        this.pageNumber = prototype.getPageNumber();
        this.isDescending = prototype.isDescending();
        this.orderField = prototype.getOrderField();
        this.filters.addAll(prototype.getFilters());
    }

    public int getRowsPerPage() {
        return this.rowsPerPage;
    }

    public void setRowsPerPage(int rowsPerPage) {
        this.rowsPerPage = rowsPerPage;
    }

    public int getPageNumber() {
        return this.pageNumber;
    }

    public void setPageNumber(int pageNumber) {
        this.pageNumber = pageNumber;
    }

    public int getStartRecord() {
        return this.getRowsPerPage() * (this.getPageNumber() - 1);
    }

    public String getOrderField() {
        return this.orderField;
    }

    public void setOrderField(String orderField) {
        this.orderField = orderField;
    }

    public boolean isDescending() {
        return this.isDescending;
    }

    public void setDescending(boolean isDescending) {
        this.isDescending = isDescending;
    }

    public List<Filter> getFilters() {
        return Collections.unmodifiableList(this.filters);
    }

    public Filter getFilter(String fieldName) {
        Filter result = null;
        for (Filter filter : this.filters) {
            if (!filter.getFieldName().equalsIgnoreCase(fieldName)) continue;
            result = filter;
            break;
        }
        return result;
    }

    public void addFilter(String fieldName, FilterType filterType, Collection<Object> values) {
        this.removeFilter(fieldName);
        this.filters.add(new Filter(fieldName, filterType, values));
    }

    public void addFilter(String fieldName, FilterType filterType, Object value) {
        ArrayList<Object> values = new ArrayList<Object>();
        values.add(value);
        this.addFilter(fieldName, filterType, values);
    }

    public void removeFilter(String fieldName) {
        this.filters.remove(this.getFilter(fieldName));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @BridgeMethodsAdded
    public static class Filter {
        final String fieldName;
        final FilterType filterType;
        final List<Object> values;

        public Filter(String fieldName, FilterType filterType, Collection<Object> values) {
            this.fieldName = fieldName;
            this.filterType = filterType;
            this.values = new ArrayList<Object>(values);
        }

        public String getFieldName() {
            return this.fieldName;
        }

        public FilterType getFilterType() {
            return this.filterType;
        }

        public List<Object> getValues() {
            return Collections.unmodifiableList(this.values);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @BridgeMethodsAdded
    public static enum FilterType {
        EQUALS,
        LIKE,
        GREATER_THAN,
        GREATER_OR_EQUAL,
        LESS_THAN,
        LESS_OR_EQUAL;


        public static FilterType fromParamValue(String paramValue) {
            FilterType result;
            if ("eq".equalsIgnoreCase(paramValue)) {
                result = EQUALS;
            } else if ("like".equalsIgnoreCase(paramValue)) {
                result = LIKE;
            } else if ("gt".equalsIgnoreCase(paramValue)) {
                result = GREATER_THAN;
            } else if ("ge".equalsIgnoreCase(paramValue)) {
                result = GREATER_OR_EQUAL;
            } else if ("lt".equalsIgnoreCase(paramValue)) {
                result = LESS_THAN;
            } else if ("le".equalsIgnoreCase(paramValue)) {
                result = LESS_OR_EQUAL;
            } else {
                throw new IllegalArgumentException("Cannot determine filter type for string: " + paramValue);
            }
            return result;
        }
    }
}

