/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.util.ssl;

import com.infradna.tool.bridge_method_injector.BridgeMethodsAdded;
import com.urbancode.commons.util.StringUtil;
import com.urbancode.commons.util.crypto.FIPSHelper;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import javax.net.ssl.SSLContext;
import org.apache.log4j.Logger;

@BridgeMethodsAdded
public class SSLContextProtocolDetector {
    private static final Logger log = Logger.getLogger(SSLContextProtocolDetector.class);
    public static final String SSL_CONTEXT_PROTOCOL = "com.urbancode.commons.util.ssl.sslContextProtocol";
    public static final String SSL_CONTEXT_PROTOCOL_ENVVAR = "UC_SSL_CONTEXT_PROTOCOL";
    public static final String SSL_CONTEXT_ENABLED_PROTOCOLS = "com.urbancode.commons.util.ssl.sslContextEnabledProtocols";
    public static final String SSL_CONTEXT_ENABLED_PROTOCOLS_ENVVAR = "UC_SSL_CONTEXT_ENABLED_PROTOCOLS";
    private static final String[] sslContextProtocols = new String[]{"TLSv1.2", "TLSv1.1", "TLSv1"};
    private static final String[] suggestedCipherSuites;

    private static final String[] parseProtocolsProperty() {
        String[] result = null;
        String protocols = SSLContextProtocolDetector.getConfiguredSSLContextEnabledProtocols();
        if (!StringUtil.isEmpty(protocols)) {
            result = protocols.split(",+");
        }
        return result;
    }

    public static String detectSslContextProtocol() {
        String result = SSLContextProtocolDetector.getConfiguredSSLContextProtocol();
        if (result == null) {
            for (String protocol : sslContextProtocols) {
                try {
                    SSLContext.getInstance(protocol);
                    result = protocol;
                    break;
                }
                catch (NoSuchAlgorithmException e) {
                }
            }
        }
        return result;
    }

    public static String[] getSuggestedCipherSuites() {
        return (String[])suggestedCipherSuites.clone();
    }

    public static String[] getSupportedCipherSuites() {
        LinkedHashSet<String> supportedCipherSuites = new LinkedHashSet<String>();
        try {
            SSLContext context = SSLContext.getInstance(SSLContextProtocolDetector.detectSslContextProtocol());
            context.init(null, null, null);
            for (String cipher : context.getSocketFactory().getSupportedCipherSuites()) {
                supportedCipherSuites.add(cipher.toUpperCase(Locale.US));
            }
        }
        catch (NoSuchAlgorithmException e) {
            return (String[])suggestedCipherSuites.clone();
        }
        catch (KeyManagementException e) {
            return (String[])suggestedCipherSuites.clone();
        }
        if (FIPSHelper.isIBMJava()) {
            ArrayList<String> additional = new ArrayList<String>();
            for (String c : supportedCipherSuites) {
                if (!c.startsWith("SSL")) continue;
                additional.add("TLS" + c.substring(3));
            }
            supportedCipherSuites.addAll(additional);
        }
        supportedCipherSuites.retainAll(Arrays.asList(suggestedCipherSuites));
        return supportedCipherSuites.toArray(new String[0]);
    }

    public static String[] getPossibleSslContextProtocols() {
        return (String[])sslContextProtocols.clone();
    }

    public static String[] getSupportedSslContextProtocols() {
        return SSLContextProtocolDetector.getSupportedSslContextProtocols(false);
    }

    public static String[] getSupportedSslContextProtocols(boolean isClient) {
        HashSet<String> result = new HashSet<String>();
        String[] protocolsToEnable = sslContextProtocols;
        String[] userSpecifiedProtocols = SSLContextProtocolDetector.parseProtocolsProperty();
        if (userSpecifiedProtocols != null) {
            protocolsToEnable = userSpecifiedProtocols;
        }
        boolean helloAdded = false;
        for (String protocol : protocolsToEnable) {
            try {
                SSLContext context = SSLContext.getInstance(protocol);
                result.add(protocol);
                if (helloAdded || isClient) continue;
                context.init(null, null, null);
                List<String> supportedProtocols = Arrays.asList(context.createSSLEngine().getSupportedProtocols());
                if (!supportedProtocols.contains("SSLv2Hello")) continue;
                result.add("SSLv2Hello");
                helloAdded = true;
            }
            catch (NoSuchAlgorithmException e) {
                log.error((Object)("No such algorithm: " + protocol));
            }
            catch (KeyManagementException e) {
                log.error((Object)("Unable to initialize SSLContext for protocol " + protocol + "."), (Throwable)e);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("getSupportedSslContextProtocols result: " + result));
        }
        return result.toArray(new String[result.size()]);
    }

    private static String getConfiguredSSLContextProtocol() {
        String protocol = StringUtil.trimToNull(System.getProperty(SSL_CONTEXT_PROTOCOL));
        if (protocol == null) {
            protocol = StringUtil.trimToNull(System.getenv(SSL_CONTEXT_PROTOCOL_ENVVAR));
        }
        return protocol;
    }

    private static String getConfiguredSSLContextEnabledProtocols() {
        String protocols = StringUtil.trimToNull(System.getProperty(SSL_CONTEXT_ENABLED_PROTOCOLS));
        if (protocols == null) {
            protocols = StringUtil.trimToNull(System.getenv(SSL_CONTEXT_ENABLED_PROTOCOLS_ENVVAR));
        }
        return protocols;
    }

    private SSLContextProtocolDetector() {
    }

    static {
        ArrayList<String> cipherSuites = new ArrayList<String>();
        InputStream suiteStream = SSLContextProtocolDetector.class.getResourceAsStream("suggestedciphersuites.txt");
        if (suiteStream == null) {
            throw new RuntimeException("Could not find resource suggestedciphersuites.txt");
        }
        try {
            BufferedReader suiteReader = new BufferedReader(new InputStreamReader(suiteStream, "UTF-8"));
            String line = "";
            while (line != null) {
                if (!(line = line.trim()).startsWith("#") && line.length() > 0) {
                    cipherSuites.add("TLS_" + line.toUpperCase(Locale.US));
                    cipherSuites.add("SSL_" + line.toUpperCase(Locale.US));
                }
                line = suiteReader.readLine();
            }
            suiteReader.close();
            suiteStream.close();
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError((Object)e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        suggestedCipherSuites = cipherSuites.toArray(new String[0]);
    }
}

