/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.server.validation;

import com.urbancode.air.plugin.server.xml.UDServerPluginXmlParser;
import com.urbancode.air.plugin_command.schema_migration.SchemaValidationException;
import com.urbancode.air.plugin_command.schema_migration.SchemaVersionDocValidator;
import java.io.InputStream;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UDV1PluginServerSchemaVersionDocValidator
extends SchemaVersionDocValidator {
    public static final String SCHEMA_FILE = "plugin_server_v1.xsd";
    public static final String SCHEMA_EXT_FILE = "plugin_server_ext_v1.xsd";
    public static final String SCHEMA_NAMESPACE = "http://www.urbancode.com/PluginXMLSchema_v1";
    public static final String SCHEMA_EXT_NAMESPACE = "http://www.urbancode.com/PluginServerXMLSchema_v1";

    public void validateDocAgainstSchema(InputStream docStream) throws SchemaValidationException {
        if (docStream == null) {
            throw new NullPointerException("DocStream can't be null.");
        }
        UDServerPluginXmlParser parsre = new UDServerPluginXmlParser();
        try {
            parsre.parse(docStream);
        }
        catch (Exception e) {
            throw new SchemaValidationException(e.getMessage(), (Throwable)e);
        }
    }

    public void validateDocAgainstSchema(Document document) throws SchemaValidationException {
        Transformer trans;
        TransformerFactory transfac = TransformerFactory.newInstance();
        try {
            trans = transfac.newTransformer();
        }
        catch (TransformerConfigurationException e1) {
            throw new SchemaValidationException((Throwable)e1);
        }
        StringWriter sw = new StringWriter();
        StreamResult result = new StreamResult(sw);
        DOMSource source = new DOMSource(document);
        try {
            trans.transform(source, result);
        }
        catch (TransformerException e) {
            throw new SchemaValidationException((Throwable)e);
        }
        String xmlString = sw.toString();
        this.validateDocAgainstSchema(xmlString);
    }

    protected List<String> getSchemaNamespaceURIs() {
        ArrayList<String> schemaFileNameList = new ArrayList<String>();
        schemaFileNameList.add(SCHEMA_EXT_NAMESPACE);
        schemaFileNameList.add(SCHEMA_NAMESPACE);
        return schemaFileNameList;
    }

    protected List<String> getSchemaFileNames() {
        ArrayList<String> schemaFileNameList = new ArrayList<String>();
        schemaFileNameList.add(SCHEMA_EXT_FILE);
        schemaFileNameList.add(SCHEMA_FILE);
        return schemaFileNameList;
    }

    public void validateDocBeyondSchema(String docText) throws SchemaValidationException {
    }
}

