/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.ud.client;

import com.urbancode.commons.util.StringUtil;
import com.urbancode.ud.client.UDRestClient;
import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPut;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnvironmentClient
extends UDRestClient {
    public EnvironmentClient(URI url, String clientUser, String clientPassword) {
        super(url, clientUser, clientPassword);
    }

    public void addEnvironmentBaseResource(String application, String environment, String resource) throws IOException {
        String uri = this.url + "/cli/environment/addBaseResource?environment=" + this.encodePath(environment) + "&resource=" + this.encodePath(resource);
        if (!StringUtils.isEmpty(application)) {
            uri = uri + "&application=" + this.encodePath(application);
        }
        HttpPut method = new HttpPut(uri);
        this.invokeMethod(method);
    }

    public void addEnvironmentToTeam(String application, String environment, String team, String type) throws IOException {
        String uri = this.url + "/cli/environment/teams?team=" + this.encodePath(team) + "&type=" + this.encodePath(type) + "&environment=" + this.encodePath(environment);
        if (!StringUtils.isEmpty(application)) {
            uri = uri + "&application=" + this.encodePath(application);
        }
        HttpPut method = new HttpPut(uri);
        this.invokeMethod(method);
    }

    public UUID createEnvironment(String applicationName, String name, String description, String color, boolean requireApprovals, String blueprintName, String baseResource) throws IOException, JSONException {
        return this.createEnvironment(applicationName, name, description, color, requireApprovals, blueprintName, baseResource, null);
    }

    public UUID createEnvironment(String applicationName, String name, String description, String color, boolean requireApprovals, String blueprintName, String baseResource, String envProfileName) throws IOException, JSONException {
        UUID result = null;
        if (StringUtils.isEmpty(blueprintName)) {
            String uri = this.url + "/cli/environment/createEnvironment?application=" + this.encodePath(applicationName) + "&name=" + this.encodePath(name) + "&description=" + this.encodePath(description) + "&color=" + this.encodePath(color) + "&requireApprovals=" + String.valueOf(requireApprovals);
            HttpPut method = new HttpPut(uri);
            HttpResponse response = this.invokeMethod(method);
            String body = this.getBody(response);
            result = UUID.fromString(body);
        } else {
            JSONObject jsonToSend = new JSONObject();
            jsonToSend.put("name", name);
            jsonToSend.put("description", description);
            jsonToSend.put("application", applicationName);
            jsonToSend.put("blueprint", blueprintName);
            jsonToSend.put("baseResource", baseResource);
            jsonToSend.put("color", color);
            jsonToSend.put("requireApprovals", requireApprovals);
            if (!StringUtil.isEmpty(envProfileName)) {
                jsonToSend.put("envProfileName", envProfileName);
            }
            String uri = this.url + "/cli/environment/provisionEnvironment";
            HttpPut method = new HttpPut(uri);
            method.setEntity(this.getStringEntity(jsonToSend));
            HttpResponse response = this.invokeMethod(method);
            String body = this.getBody(response);
            JSONObject jsonBody = new JSONObject(body);
            result = UUID.fromString(jsonBody.getString("id"));
        }
        return result;
    }

    public UUID provisionEnvironment(String applicationName, String name, String description, String color, boolean requireApprovals) throws IOException {
        UUID result = null;
        String uri = this.url + "/cli/environment/createEnvironment?application=" + this.encodePath(applicationName) + "&name=" + this.encodePath(name) + "&description=" + this.encodePath(description) + "&color=" + this.encodePath(color) + "&requireApprovals=" + String.valueOf(requireApprovals);
        HttpPut method = new HttpPut(uri);
        HttpResponse response = this.invokeMethod(method);
        String body = this.getBody(response);
        result = UUID.fromString(body);
        return result;
    }

    public void deleteEnvironment(String applicationName, String name) throws IOException {
        String uri = this.url + "/cli/environment/deleteEnvironment?environment=" + this.encodePath(name);
        if (!StringUtils.isEmpty(applicationName)) {
            uri = uri + "&application=" + this.encodePath(applicationName);
        }
        HttpDelete method = new HttpDelete(uri);
        this.invokeMethod(method);
    }

    public Map<String, String> getComponentEnvironmentProperties(String compName, String envName, String appName) throws IOException, JSONException {
        HashMap<String, String> result = new HashMap<String, String>();
        if ("".equals(envName) || "".equals(appName)) {
            throw new IOException("a required argument was not supplied");
        }
        String uri = this.url + "/cli/environment/componentProperties?environment=" + this.encodePath(envName) + "&component=" + this.encodePath(compName);
        if (!StringUtils.isEmpty(appName)) {
            uri = uri + "&application=" + this.encodePath(appName);
        }
        HttpGet method = new HttpGet(uri);
        HttpResponse response = this.invokeMethod(method);
        String body = this.getBody(response);
        JSONArray propsJSON = new JSONArray(body);
        for (int i = 0; i < propsJSON.length(); ++i) {
            JSONObject propObject = (JSONObject)propsJSON.get(i);
            result.put((String)propObject.get("name"), (String)propObject.get("value"));
        }
        return result;
    }

    public Map<String, String> getEnvironmentProperties(String envName, String appName) throws IOException, JSONException {
        HashMap<String, String> result = new HashMap<String, String>();
        if ("".equals(envName) || "".equals(appName)) {
            throw new IOException("a required argument was not supplied");
        }
        String uri = this.url + "/cli/environment/getProperties?environment=" + this.encodePath(envName);
        if (!StringUtils.isEmpty(appName)) {
            uri = uri + "&application=" + this.encodePath(appName);
        }
        HttpGet method = new HttpGet(uri);
        HttpResponse response = this.invokeMethod(method);
        String body = this.getBody(response);
        JSONArray propsJSON = new JSONArray(body);
        for (int i = 0; i < propsJSON.length(); ++i) {
            JSONObject propObject = (JSONObject)propsJSON.get(i);
            result.put((String)propObject.get("name"), (String)propObject.get("value"));
        }
        return result;
    }

    public UUID getEnvironmentUUID(String environmentName, String applicationName) throws IOException, JSONException {
        UUID result = null;
        String uri = this.url + "/cli/environment/info?environment=" + this.encodePath(environmentName);
        if (applicationName != null && !"".equals(applicationName)) {
            uri = uri + "&application=" + this.encodePath(applicationName);
        }
        HttpGet method = new HttpGet(uri);
        HttpResponse response = this.invokeMethod(method);
        String body = this.getBody(response);
        JSONObject resultJSON = new JSONObject(body);
        result = UUID.fromString(resultJSON.getString("id"));
        return result;
    }

    public JSONObject getEnvironment(String environmentName, String applicationName) throws IOException, JSONException {
        String uri = this.url + "/cli/environment/info?environment=" + this.encodePath(environmentName);
        if (applicationName != null && !"".equals(applicationName)) {
            uri = uri + "&application=" + this.encodePath(applicationName);
        }
        HttpGet method = new HttpGet(uri);
        HttpResponse response = this.invokeMethod(method);
        String body = this.getBody(response);
        return new JSONObject(body);
    }

    public void removeEnvironmentBaseResource(String application, String environment, String resource) throws IOException {
        String uri = this.url + "/cli/environment/removeBaseResource?environment=" + this.encodePath(environment) + "&resource=" + this.encodePath(resource);
        if (!StringUtils.isEmpty(application)) {
            uri = uri + "&application=" + this.encodePath(application);
        }
        HttpPut method = new HttpPut(uri);
        this.invokeMethod(method);
    }

    public String setComponentEnvironmentProperty(String componentName, String envName, String appName, String name, String value, boolean isSecure) throws IOException {
        if ("".equals(componentName) || "".equals(name) || "".equals(envName)) {
            throw new IOException("a required argument was not supplied");
        }
        String uri = this.url + "/cli/environment/componentProperties?component=" + this.encodePath(componentName) + "&environment=" + this.encodePath(envName) + "&name=" + this.encodePath(name) + "&value=" + this.encodePath(value) + "&isSecure=" + this.encodePath(String.valueOf(isSecure));
        if (appName != null && !"".equals(appName)) {
            uri = uri + "&application=" + this.encodePath(appName);
        }
        HttpPut method = new HttpPut(uri);
        this.invokeMethod(method);
        String result = isSecure ? name + "=****" : name + "=" + value;
        return result;
    }

    public String setEnvironmentProperty(String envName, String appName, String name, String value, boolean isSecure) throws IOException {
        if ("".equals(envName) || "".equals(name)) {
            throw new IOException("a required argument was not supplied");
        }
        String uri = this.url + "/cli/environment/propValue?environment=" + this.encodePath(envName) + "&name=" + this.encodePath(name) + "&value=" + this.encodePath(value) + "&isSecure=" + this.encodePath(String.valueOf(isSecure));
        if (!StringUtils.isEmpty(appName)) {
            uri = uri + "&application=" + this.encodePath(appName);
        }
        HttpPut method = new HttpPut(uri);
        this.invokeMethod(method);
        String result = isSecure ? name + "=****" : name + "=" + value;
        return result;
    }

    public boolean verifyInventoryStatus(String envName, String appName, String componentName, String componentVersion, String inventoryStatus) throws IOException, JSONException {
        boolean result = false;
        boolean isID = false;
        try {
            UUID envUUID = UUID.fromString(envName);
            isID = true;
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        String envID = isID ? envName : this.getEnvironmentUUID(envName, appName).toString();
        String uri = this.url + "/rest/inventory/desiredInventory/" + this.encodePath(envID);
        HttpGet method = new HttpGet(uri);
        HttpResponse response = this.invokeMethod(method);
        String body = this.getBody(response);
        JSONArray responseJSON = new JSONArray(body);
        try {
            for (int i = 0; i < responseJSON.length(); ++i) {
                JSONObject statusObj;
                JSONObject versionObj;
                JSONObject obj = responseJSON.getJSONObject(i);
                JSONObject componentObj = obj.getJSONObject("component");
                if (!componentObj.getString("name").equals(componentName) || !(versionObj = obj.getJSONObject("version")).getString("name").equals(componentVersion) || !(statusObj = obj.getJSONObject("status")).getString("name").equals(inventoryStatus)) continue;
                result = true;
                break;
            }
        }
        catch (JSONException e) {
            result = false;
        }
        return result;
    }

    public JSONObject getLatestEnvironmentInventoryByComponent(String envName, String appName, String compName) throws IOException, JSONException {
        UUID envId = this.getEnvironmentUUID(envName, appName);
        String uri = this.url + "/rest/inventory/versionByEnvironmentAndComponent/" + envId.toString() + "/" + compName;
        HttpGet method = new HttpGet(uri);
        HttpResponse response = this.invokeMethod(method);
        String body = this.getBody(response);
        JSONObject result = new JSONObject(body);
        return result;
    }

    public JSONArray deleteRedundantVersions(String envName, String appName, String compName, boolean deleteRedundant) throws IOException, JSONException {
        if ("".equals(envName) || "".equals(appName) || "".equals(compName)) {
            throw new IOException("a required argument was not supplied");
        }
        UUID envId = this.getEnvironmentUUID(envName, appName);
        String uri = this.url + "/cli/environment/" + envId.toString() + "/redundantVersions/" + this.encodePath(compName) + "?deleteRedundant=" + String.valueOf(deleteRedundant);
        HttpDelete method = new HttpDelete(uri);
        HttpResponse response = this.invokeMethod(method);
        String body = this.getBody(response);
        JSONArray versionsJson = new JSONArray(body);
        return versionsJson;
    }

    public JSONArray deleteAllVersions(String envName, String appName, String compName, boolean deleteVersions) throws IOException, JSONException {
        if ("".equals(envName) || "".equals(appName) || "".equals(compName)) {
            throw new IOException("a required argument was not supplied");
        }
        UUID envId = this.getEnvironmentUUID(envName, appName);
        String uri = this.url + "/cli/environment/" + envId.toString() + "/versions/" + this.encodePath(compName) + "?deleteVersions=" + String.valueOf(deleteVersions);
        HttpDelete method = new HttpDelete(uri);
        HttpResponse response = this.invokeMethod(method);
        String body = this.getBody(response);
        JSONArray versionsJson = new JSONArray(body);
        return versionsJson;
    }
}

