/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.ud.client;

import com.urbancode.ud.client.UDRestClient;
import java.io.IOException;
import java.net.URI;
import java.util.UUID;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public class PropertyClient
extends UDRestClient {
    public PropertyClient(URI url, String clientUser, String clientPassword) {
        super(url, clientUser, clientPassword);
    }

    public UUID createPropDef(UUID propSheetId, String name, String label, String value, Boolean required, String description, String type) throws IOException, JSONException {
        String uri = this.url + "/rest/property/propDef";
        JSONObject propDefObject = new JSONObject();
        propDefObject.put("name", name);
        propDefObject.put("label", label);
        propDefObject.put("description", description);
        propDefObject.put("required", required);
        propDefObject.put("type", type);
        propDefObject.put("definitionGroupId", propSheetId);
        HttpPost method = new HttpPost(uri);
        method.setEntity(this.getStringEntity(propDefObject));
        HttpResponse response = this.invokeMethod(method);
        String body = this.getBody(response);
        UUID result = UUID.fromString(new JSONObject(body).getString("id"));
        return result;
    }

    public JSONArray getPropSheetDefPropDefs(String id) throws IOException, JSONException {
        JSONArray result = null;
        String uri = this.url + "/property/propSheetDef/" + this.encodePath(id) + "/propDefs";
        HttpGet method = new HttpGet(uri);
        HttpResponse response = this.invokeMethod(method);
        String body = this.getBody(response);
        result = new JSONArray(body);
        return result;
    }

    public JSONArray updatePropDefs(String propSheetDefPath, JSONArray propDefs, boolean deleteExtraProps) throws IOException, JSONException {
        JSONArray result = null;
        String uri = this.url + "/property/propSheetDef/" + this.encodePath(propSheetDefPath) + "/propDefs/update/" + String.valueOf(deleteExtraProps);
        HttpPut method = new HttpPut(uri);
        method.setEntity(this.getStringEntity(propDefs));
        HttpResponse response = this.invokeMethod(method);
        String body = this.getBody(response);
        result = new JSONArray(body);
        return result;
    }
}

