/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.util.ssl;

import com.infradna.tool.bridge_method_injector.BridgeMethodsAdded;
import com.urbancode.commons.util.ssl.SSLConfiguratorPolicy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@BridgeMethodsAdded
public class SSLConfiguratorDefaultPolicy
implements SSLConfiguratorPolicy {
    private static final String SSLv2Hello = "SSLv2Hello";
    public static final String POLICY_PROTO_CONFIG_PROPERTY = "SSLConfiguratorDefaultPolicy.protoconfig";
    private static final String[] DEFAULT_WHITE_PROTOS = new String[]{"TLSv1.2", "TLSv1.1", "TLSv1"};
    private static final String[] DEFAULT_BLACK_PROTOS = new String[]{"SSLv2", "SSLv3"};
    public static final String POLICY_CIPHER_CONFIG_PROPERTY = "SSLConfiguratorDefaultPolicy.cipherconfig";
    private static final String[] DEFAULT_WHITE_CIPHERS = new String[0];
    private static final String[] DEFAULT_BLACK_CIPHERS = new String[0];
    private String[] whiteProtos;
    private String[] blackProtos;
    private String[] whiteCiphers;
    private String[] blackCiphers;

    public SSLConfiguratorDefaultPolicy() {
        HashSet<String> whiteProtos = new HashSet<String>();
        Collections.addAll(whiteProtos, DEFAULT_WHITE_PROTOS);
        HashSet<String> blackProtos = new HashSet<String>();
        Collections.addAll(blackProtos, DEFAULT_BLACK_PROTOS);
        HashSet<String> whiteCiphers = new HashSet<String>();
        Collections.addAll(whiteCiphers, DEFAULT_WHITE_CIPHERS);
        HashSet<String> blackCiphers = new HashSet<String>();
        Collections.addAll(blackCiphers, DEFAULT_BLACK_CIPHERS);
        String protoString = System.getProperty(POLICY_PROTO_CONFIG_PROPERTY);
        List<String> protoConfig = this.split(protoString);
        for (String elem : protoConfig) {
            if (elem.startsWith("+")) {
                whiteProtos.add(elem.substring(1));
                blackProtos.remove(elem.substring(1));
                continue;
            }
            if (elem.startsWith("-")) {
                blackProtos.add(elem.substring(1));
                whiteProtos.remove(elem.substring(1));
                continue;
            }
            whiteProtos.add(elem);
        }
        this.whiteProtos = whiteProtos.toArray(new String[0]);
        this.blackProtos = blackProtos.toArray(new String[0]);
        String cipherString = System.getProperty(POLICY_CIPHER_CONFIG_PROPERTY);
        List<String> cipherConfig = this.split(cipherString);
        for (String elem : cipherConfig) {
            if (elem.startsWith("+")) {
                whiteCiphers.add(elem.substring(1));
                blackCiphers.remove(elem.substring(1));
                continue;
            }
            if (elem.startsWith("-")) {
                blackCiphers.add(elem.substring(1));
                whiteCiphers.remove(elem.substring(1));
                continue;
            }
            whiteCiphers.add(elem);
        }
        this.whiteCiphers = whiteCiphers.toArray(new String[0]);
        this.blackCiphers = blackCiphers.toArray(new String[0]);
    }

    @Override
    public String[] enabledProtocols(String[] supportedProtocols, boolean server) {
        LinkedHashSet<String> enabledProtos = new LinkedHashSet<String>();
        enabledProtos.addAll(Arrays.asList(supportedProtocols));
        if (this.whiteProtos.length > 0) {
            enabledProtos.retainAll(Arrays.asList(this.whiteProtos));
        }
        if (this.blackProtos.length > 0) {
            enabledProtos.removeAll(Arrays.asList(this.blackProtos));
        }
        if (!server) {
            enabledProtos.remove(SSLv2Hello);
        }
        return enabledProtos.toArray(new String[enabledProtos.size()]);
    }

    @Override
    public String[] enabledCipherSuites(String[] supportedCipherSuites) {
        LinkedHashSet enabledCipherSuites = new LinkedHashSet();
        Collections.addAll(enabledCipherSuites, supportedCipherSuites);
        LinkedHashSet supportedWhiteChipers = new LinkedHashSet();
        Collections.addAll(supportedWhiteChipers, supportedCipherSuites);
        supportedWhiteChipers.retainAll(Arrays.asList(this.whiteCiphers));
        Iterator itr = enabledCipherSuites.iterator();
        while (itr.hasNext()) {
            String cipher = (String)itr.next();
            if (cipher.contains("_anon_")) {
                itr.remove();
                continue;
            }
            if (cipher.contains("_EXPORT_") || cipher.contains("_EXPORT1024_")) {
                itr.remove();
                continue;
            }
            if (cipher.contains("_NULL_")) {
                itr.remove();
                continue;
            }
            if (cipher.contains("_DES_")) {
                itr.remove();
                continue;
            }
            if (cipher.contains("_3DES_")) {
                itr.remove();
                continue;
            }
            if (cipher.contains("_DH_") || cipher.contains("_DHE_")) {
                itr.remove();
                continue;
            }
            if (cipher.contains("_RC4_")) {
                itr.remove();
                continue;
            }
            if (!cipher.contains("_MD5")) continue;
            itr.remove();
        }
        enabledCipherSuites.addAll(supportedWhiteChipers);
        if (this.blackCiphers.length > 0) {
            enabledCipherSuites.removeAll(Arrays.asList(this.blackCiphers));
        }
        return enabledCipherSuites.toArray(new String[enabledCipherSuites.size()]);
    }

    private List<String> split(String value) {
        ArrayList<String> result = new ArrayList<String>();
        if (value != null) {
            for (String token : value.split(",")) {
                if ((token = token.trim()).length() <= 0) continue;
                result.add(token);
            }
        }
        return result;
    }
}

