/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.io;

import com.urbancode.commons.io.BufferOutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class StreamBuffer {
    private static final Logger log = Logger.getLogger(StreamBuffer.class);
    public static final int END_OF_FILE = -1;
    public static final int SIZE = 256;
    private int initialSize = 256;
    private byte[] buf = null;
    private int size = 0;
    private List feederList = new ArrayList();

    public StreamBuffer() {
        this(256);
    }

    public StreamBuffer(int initialSize) {
        this.initialSize = initialSize;
        this.buf = new byte[initialSize];
    }

    public synchronized void write(byte[] data, int offset, int len) {
        if (data == null) {
            throw new NullPointerException();
        }
        if (offset < 0 || offset > data.length || len < 0 || offset + len > data.length) {
            throw new IndexOutOfBoundsException();
        }
        if (this.buf.length - this.size < len) {
            byte[] temp = new byte[this.buf.length + len + this.initialSize];
            System.arraycopy(this.buf, 0, temp, 0, this.size);
            this.buf = temp;
        }
        System.arraycopy(data, offset, this.buf, this.size, len);
        this.size += len;
        this.notify();
    }

    public synchronized void write(int b) {
        if (this.buf.length == this.size) {
            byte[] temp = new byte[this.size + this.initialSize];
            System.arraycopy(this.buf, 0, temp, 0, this.size);
            this.buf = temp;
        }
        this.buf[this.size++] = (byte)b;
        this.notify();
    }

    public synchronized int read(byte[] data, int offset, int len) {
        if (data == null) {
            throw new NullPointerException();
        }
        if (offset < 0 || offset > data.length || len < 0 || offset + len > data.length) {
            throw new IndexOutOfBoundsException();
        }
        int result = 0;
        while (this.size == 0 && !this.isClosed()) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                log.error((Object)e, (Throwable)e);
            }
        }
        if (len < this.size) {
            result = len;
            System.arraycopy(this.buf, 0, data, offset, result);
            int newSize = this.buf.length - result;
            if (newSize < this.initialSize) {
                newSize = this.initialSize;
            }
            byte[] temp = new byte[newSize];
            System.arraycopy(this.buf, len, temp, 0, this.size - len);
            this.buf = temp;
            this.size -= len;
        } else if (this.size > 0) {
            result = this.size;
            System.arraycopy(this.buf, 0, data, offset, result);
            this.buf = new byte[this.initialSize];
            this.size = 0;
        } else if (this.isClosed()) {
            result = -1;
        }
        return result;
    }

    public synchronized int read() {
        int result = 0;
        while (this.size == 0 && !this.isClosed()) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                log.error((Object)e, (Throwable)e);
            }
        }
        if (this.size > 1) {
            result = this.buf[0] & 0xFF;
            --this.size;
            System.arraycopy(this.buf, 1, this.buf, 0, this.size);
        } else if (this.isClosed()) {
            result = -1;
        }
        return result;
    }

    public synchronized int available() {
        return this.size;
    }

    public synchronized boolean isClosed() {
        return this.feederList.isEmpty();
    }

    protected synchronized void addFeeder(BufferOutputStream feeder) {
        this.feederList.add(feeder);
    }

    protected synchronized void removeFeeder(BufferOutputStream feeder) {
        this.feederList.remove(feeder);
        this.notify();
    }
}

