/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.ds.client;

import com.urbancode.commons.util.IO;
import com.urbancode.commons.util.Paths;
import com.urbancode.commons.util.UnsafePathException;
import com.urbancode.commons.xml.DOMUtils;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.concurrent.Callable;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.http.Header;
import org.apache.http.HeaderElement;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.ContentType;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class HttpMethodCallable
implements Callable<Integer> {
    private final HttpClient client;
    private final HttpRequestBase method;
    private final PrintStream out;
    private final PrintStream err;
    private final FileFactory ff;
    private final Util util;

    public static HttpMethodCallable create(HttpClient client, HttpRequestBase method, PrintStream defaultOut, PrintStream err) {
        return new HttpMethodCallable(client, method, defaultOut, err);
    }

    private HttpMethodCallable(HttpClient client, HttpRequestBase method, PrintStream defaultOut, PrintStream err) {
        this(client, method, defaultOut, err, new FileFactory(), new Util());
    }

    HttpMethodCallable(HttpClient client, HttpRequestBase method, PrintStream defaultOut, PrintStream err, FileFactory ff, Util util) {
        this.client = Objects.requireNonNull(client);
        this.method = Objects.requireNonNull(method);
        this.out = Objects.requireNonNull(defaultOut);
        this.err = Objects.requireNonNull(err);
        this.ff = Objects.requireNonNull(ff);
        this.util = util;
        this.util.getClass();
    }

    @Override
    public Integer call() throws Exception {
        return this.executeMethod();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int executeMethod() throws Exception {
        int responseCode;
        block3: {
            HttpEntity entity;
            block4: {
                HttpResponse response;
                block2: {
                    response = this.client.execute(this.method);
                    responseCode = response.getStatusLine().getStatusCode();
                    if (responseCode != 302) break block2;
                    Header locationHeader = response.getFirstHeader("Location");
                    this.method.setURI(URI.create(locationHeader.getValue()));
                    responseCode = this.executeMethod();
                    break block3;
                }
                entity = response.getEntity();
                String destination = this.getFileOutputLocation(response);
                if (destination == null) break block4;
                FileOutputStream os = null;
                PrintStream fps = null;
                try {
                    os = this.ff.createFOS(destination);
                    fps = this.ff.createPrintStream(os);
                    this.writeOutput(fps, this.err, responseCode, entity);
                }
                catch (Throwable throwable) {
                    IO.close(os);
                    IO.close(fps);
                    throw throwable;
                }
                IO.close(os);
                IO.close(fps);
                this.out.println("File written to: " + destination);
                break block3;
            }
            this.writeOutput(this.out, this.err, responseCode, entity);
        }
        return responseCode;
    }

    private String getFileOutputLocation(HttpResponse response) throws UnsafePathException {
        String result = null;
        Header contentDisp = response.getFirstHeader("Content-Disposition");
        if (contentDisp != null) {
            NameValuePair filename;
            HeaderElement attachmentHeaderElem = null;
            for (HeaderElement header : contentDisp.getElements()) {
                if (!header.getName().equals("attachment")) continue;
                attachmentHeaderElem = header;
                break;
            }
            if (attachmentHeaderElem != null && (filename = attachmentHeaderElem.getParameterByName("filename")) != null && !Paths.isPathSafe(result = Paths.forceRelativePath(filename.getValue()))) {
                throw new UnsafePathException("Unsafe path in content-disposition: " + result);
            }
        }
        return result;
    }

    private void writeOutput(PrintStream out, PrintStream err, int responseCode, HttpEntity entity) throws IOException {
        if (this.isGoodResponseCode(responseCode)) {
            if (entity == null || entity.getContent() == null) {
                out.println("Operation succeeded.");
            } else {
                ContentType ct = this.util.getContentType(entity);
                Charset cs = StandardCharsets.UTF_8;
                if (ct != null && ct.getCharset() != null) {
                    cs = ct.getCharset();
                }
                if (this.isOctetStream(ct)) {
                    this.ff.copy(entity.getContent(), out);
                } else if (this.isXML(ct)) {
                    String responseString = IO.readText(entity.getContent(), cs);
                    try {
                        Document doc = this.util.loadDocument(responseString);
                        out.println(this.util.documentToString(doc));
                    }
                    catch (Exception e) {
                        out.println(responseString);
                    }
                    out.println();
                } else {
                    String responseString = IO.readText(entity.getContent(), cs);
                    try {
                        JSONObject responseJsonObject = new JSONObject(responseString);
                        out.println(responseJsonObject.toString(2));
                    }
                    catch (JSONException e) {
                        try {
                            JSONArray responseJsonArray = new JSONArray(responseString);
                            out.println(responseJsonArray.toString(2));
                        }
                        catch (JSONException e2) {
                            out.print(responseString);
                        }
                    }
                    out.println();
                }
            }
        } else if (entity == null || entity.getContent() == null) {
            err.println("Operation failed: " + responseCode);
        } else {
            err.println(IO.readText(entity.getContent(), "UTF-8"));
        }
    }

    private boolean isXML(ContentType ct) {
        if (ct == null) {
            return false;
        }
        return ct.getMimeType().equalsIgnoreCase(ContentType.APPLICATION_XML.getMimeType());
    }

    private boolean isGoodResponseCode(int responseCode) {
        return responseCode >= 200 && responseCode < 300;
    }

    private boolean isOctetStream(ContentType ct) {
        if (ct == null) {
            return false;
        }
        return ct.getMimeType().equalsIgnoreCase(ContentType.APPLICATION_OCTET_STREAM.getMimeType());
    }

    static class FileFactory {
        FileFactory() {
        }

        FileOutputStream createFOS(String path) throws FileNotFoundException {
            return new FileOutputStream(path);
        }

        PrintStream createPrintStream(OutputStream os) {
            return new PrintStream(os);
        }

        void copy(InputStream is, OutputStream os) throws IOException {
            IO.copy(is, os);
        }
    }

    static class Util {
        Util() {
        }

        Document loadDocument(String xml) throws ParserConfigurationException, SAXException, IOException {
            return DOMUtils.loadDocument(xml);
        }

        String documentToString(Document doc) {
            return DOMUtils.documentToString(doc, true);
        }

        public ContentType getContentType(HttpEntity entity) {
            return ContentType.get(entity);
        }
    }
}

