/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.util.concurrent;

import com.urbancode.commons.util.Check;
import com.urbancode.commons.util.Exceptions;
import com.urbancode.commons.util.concurrent.AtomicStartSupport;
import com.urbancode.commons.util.concurrent.once.RunOnce;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

public abstract class Service {
    private final AtomicStartSupport atomicStartSupport = new AtomicStartSupport();
    private final Runnable completeStopAction = new RunOnce(){

        @Override
        protected void doRun() {
            try {
                Logger log = Service.this.getLogger();
                try {
                    Service.this.releaseResources();
                }
                catch (Throwable t) {
                    log.error("Exception while releasing resources", t);
                }
                if (log.isDebugEnabled()) {
                    log.debug(this.getClass().getSimpleName() + " stopped");
                }
            }
            finally {
                Service.this.shutdownLatch.countDown();
            }
        }
    };
    private final CountDownLatch shutdownLatch;
    private volatile boolean stopped;

    public static void stop(Service service) {
        if (service != null) {
            service.stop();
        }
    }

    public static void shutdownNow(ExecutorService executor) {
        if (executor != null) {
            executor.shutdownNow();
        }
    }

    public static void awaitTermination(ExecutorService executor) throws InterruptedException {
        if (executor != null) {
            executor.awaitTermination(Long.MAX_VALUE, TimeUnit.SECONDS);
        }
    }

    protected static void interrupt(Thread thread) {
        if (thread != null) {
            thread.interrupt();
        }
    }

    protected static void join(Thread thread) throws InterruptedException {
        if (thread != null && thread != Thread.currentThread()) {
            thread.join();
        }
    }

    protected Service(CountDownLatch shutdownLatch) {
        this.shutdownLatch = Check.nonNull(shutdownLatch, "shutdownLatch");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        block13: {
            Logger log = this.getLogger();
            this.atomicStartSupport.assertNotStartedAndSetStarted();
            try {
                this.acquireResources();
                if (log.isDebugEnabled()) {
                    log.debug(this.getClass().getSimpleName() + " started");
                }
            }
            catch (Throwable t) {
                try {
                    log.error(this.getClass().getSimpleName() + " failed during start", t);
                    try {
                        this.beginStop();
                    }
                    finally {
                        this.completeStop();
                    }
                }
                catch (Throwable throwable) {
                    Exceptions.throwIt(t);
                    break block13;
                }
                catch (Throwable throwable) {
                    Exceptions.throwIt(t);
                    throw throwable;
                }
                Exceptions.throwIt(t);
            }
            finally {
                if (this.stopped) {
                    this.beginStop();
                }
            }
        }
    }

    public void stop() {
        if (this.atomicStartSupport.isStarted()) {
            this.stopped = true;
            this.beginStop();
        }
    }

    protected void assertNotStart() {
        this.atomicStartSupport.assertNotStarted();
    }

    protected void assertStarted() {
        this.atomicStartSupport.assertStarted();
    }

    protected void completeStop() {
        this.completeStopAction.run();
    }

    protected abstract void beginStop();

    protected abstract void acquireResources() throws Exception;

    protected abstract void releaseResources();

    protected abstract Logger getLogger();
}

