/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.command;

import com.urbancode.commons.util.IO;
import com.urbancode.commons.util.StringUtil;
import com.urbancode.commons.util.processes.Processes;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.util.ArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AzureSourceClient {
    private final String tfExePath;
    private final String url;
    private final String username;
    private final String password;

    private static boolean pathContainsExecutable(String path) {
        return path != null && (path.toLowerCase().endsWith("tf") || path.toLowerCase().endsWith("tf.exe") || path.toLowerCase().endsWith("tf.cmd"));
    }

    public AzureSourceClient(String tfExePath, String url, String username, String password) throws IOException {
        this.tfExePath = tfExePath == null || tfExePath.equals("") ? "tf" : (AzureSourceClient.pathContainsExecutable(tfExePath) ? tfExePath : tfExePath + "\\tf.exe");
        this.url = url;
        this.username = StringUtil.trimToNull(username);
        this.password = StringUtil.trimToNull(password);
    }

    public boolean workspaceExists(String workspace) throws IOException {
        boolean workspaceExists = false;
        ArrayList<String> command = new ArrayList<String>();
        command.add(this.tfExePath);
        command.add("workspaces");
        command.add("/server:" + this.url);
        command.add("/format:brief");
        if (this.username != null && this.password != null) {
            command.add("/login:" + this.username + "," + this.password);
        }
        System.out.println("Checking for the existence of TFS workspace: " + workspace);
        System.out.println("Checking for the existence of TFS command: " + command);
        ProcessBuilder builder = new ProcessBuilder(command);
        Processes processes = new Processes();
        Process process = builder.start();
        try {
            Future<String> errorFuture = processes.getErrorStringFuture(process);
            BufferedReader outputReader = IO.buffer(IO.reader(process.getInputStream()));
            boolean inWorkspaceList = false;
            String line = null;
            while ((line = outputReader.readLine()) != null) {
                if (line.startsWith("---------")) {
                    inWorkspaceList = true;
                    continue;
                }
                if (!inWorkspaceList || !line.startsWith(workspace + " ")) continue;
                inWorkspaceList = false;
                workspaceExists = true;
            }
            int status = process.waitFor();
            if (status != 0) {
                throw new IOException("Get Workspaces Error: " + errorFuture.get());
            }
        }
        catch (InterruptedException e) {
            throw (IOException)new InterruptedIOException().initCause(e);
        }
        catch (ExecutionException e) {
            throw (IOException)new IOException(e.getMessage()).initCause(e);
        }
        finally {
            process.destroy();
        }
        System.out.println("workspace '" + workspace + "' exists: " + workspaceExists);
        return workspaceExists;
    }

    public void createWorkspace(String workspace) throws IOException {
        ArrayList<String> command = new ArrayList<String>();
        command.add(this.tfExePath);
        command.add("workspace");
        command.add("/new");
        command.add("/noprompt");
        command.add("/collection:" + this.url);
        if (this.username != null && this.password != null) {
            command.add("/login:" + this.username + "," + this.password);
        }
        command.add(workspace);
        System.out.println("Creating workspace: " + workspace);
        System.out.println("Creating command: " + command);
        ProcessBuilder builder = new ProcessBuilder(command);
        Processes processes = new Processes();
        Process process = builder.start();
        try {
            Future<String> errorFuture = processes.getErrorStringFuture(process);
            IO.copy(process.getInputStream(), IO.NULL);
            int status = process.waitFor();
            if (status != 0) {
                throw new IOException("Create Workspace Error: " + errorFuture.get());
            }
        }
        catch (InterruptedException e) {
            throw (IOException)new InterruptedIOException().initCause(e);
        }
        catch (ExecutionException e) {
            throw (IOException)new IOException(e.getMessage()).initCause(e);
        }
        finally {
            process.destroy();
        }
    }

    public void deleteWorkspace(String workspace) throws IOException {
        ArrayList<String> command = new ArrayList<String>();
        command.add(this.tfExePath);
        command.add("workspace");
        command.add("/delete");
        if (this.username != null && this.password != null) {
            command.add("/login:" + this.username + "," + this.password);
        }
        command.add(workspace);
        System.out.println("Deleting workspace: " + workspace);
        System.out.println("Deleting workspace: " + command);
        ProcessBuilder builder = new ProcessBuilder(command);
        Processes processes = new Processes();
        Process process = builder.start();
        try {
            Future<String> errorFuture = processes.getErrorStringFuture(process);
            IO.copy(process.getInputStream(), IO.NULL);
            int status = process.waitFor();
            if (status != 0) {
                throw new IOException("Create Workspace Error: " + errorFuture.get());
            }
        }
        catch (InterruptedException e) {
            throw (IOException)new InterruptedIOException().initCause(e);
        }
        catch (ExecutionException e) {
            throw (IOException)new IOException(e.getMessage()).initCause(e);
        }
        finally {
            process.destroy();
        }
    }

    public void mapWorkspace(String workspace, String serverFolder, String localFolder) throws IOException {
        ArrayList<String> command = new ArrayList<String>();
        command.add(this.tfExePath);
        command.add("workfold");
        command.add("/map");
        command.add("/collection:" + this.url);
        if (this.username != null && this.password != null) {
            command.add("/login:" + this.username + "," + this.password);
        }
        command.add("/workspace:" + workspace);
        command.add(serverFolder);
        command.add(localFolder);
        System.out.println("Mapping Azure DevOps workspace " + command);
        System.out.println("Mapping Azure DevOps workspace '" + workspace + "' to content '" + serverFolder + "' at '" + localFolder + "'");
        ProcessBuilder builder = new ProcessBuilder(command);
        Processes processes = new Processes();
        Process process = builder.start();
        try {
            Future<String> errorFuture = processes.getErrorStringFuture(process);
            IO.copy(process.getInputStream(), IO.NULL);
            int status = process.waitFor();
            if (status != 0) {
                throw new IOException("Azure DevOps Map Workspace Error: " + errorFuture.get());
            }
        }
        catch (InterruptedException e) {
            throw (IOException)new InterruptedIOException().initCause(e);
        }
        catch (ExecutionException e) {
            throw (IOException)new IOException(e.getMessage()).initCause(e);
        }
        finally {
            process.destroy();
        }
    }

    protected void get(String serverFolder, String localFolder, boolean force, String versionSpec) throws IOException {
        ArrayList<String> command = new ArrayList<String>();
        command.add(this.tfExePath);
        command.add("get");
        command.add("/noprompt");
        command.add("/recursive");
        if (force) {
            command.add("/force");
        }
        if (this.username != null && this.password != null) {
            command.add("/login:" + this.username + "," + this.password);
        }
        command.add("/version:" + versionSpec);
        command.add(serverFolder);
        System.out.println("Getting TFS command: " + command);
        System.out.println("Getting TFS content: " + serverFolder);
        File execDir = new File(localFolder);
        execDir.mkdirs();
        ProcessBuilder builder = new ProcessBuilder(command);
        builder.directory(execDir);
        Processes processes = new Processes();
        Process process = builder.start();
        try {
            Future<String> errorFuture = processes.getErrorStringFuture(process);
            IO.copy(process.getInputStream(), IO.NULL);
            int status = process.waitFor();
            if (status != 0) {
                throw new IOException("Azure DevOps Get Error: " + errorFuture.get());
            }
        }
        catch (InterruptedException e) {
            throw (IOException)new InterruptedIOException().initCause(e);
        }
        catch (ExecutionException e) {
            throw (IOException)new IOException(e.getMessage()).initCause(e);
        }
        finally {
            process.destroy();
        }
    }

    public String getLatestVersionName(String serverFolder, String localFolder) throws IOException {
        String result = null;
        ArrayList<String> command = new ArrayList<String>();
        command.add(this.tfExePath);
        command.add("history");
        command.add("/noprompt");
        command.add("/recursive");
        command.add("/collection:" + this.url);
        if (this.username != null && this.password != null) {
            command.add("/login:" + this.username + "," + this.password);
        }
        command.add("/version:T");
        command.add(serverFolder);
        System.out.println("Getting TFS history: " + serverFolder);
        System.out.println("Getting TFS history command: " + command);
        File execDir = new File(localFolder);
        execDir.mkdirs();
        ProcessBuilder builder = new ProcessBuilder(command);
        builder.directory(execDir);
        Processes processes = new Processes();
        Process process = builder.start();
        try {
            String line;
            Future<String> errorFuture = processes.getErrorStringFuture(process);
            BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            boolean found = false;
            while ((line = reader.readLine()) != null) {
                Pattern pattern;
                Matcher matcher;
                if (found || !(matcher = (pattern = Pattern.compile("^([0-9]+).*")).matcher(line)).matches()) continue;
                result = matcher.group(1);
                found = true;
            }
            int status = process.waitFor();
            if (status != 0) {
                throw new IOException("Azure DevOps history Error: " + errorFuture.get());
            }
        }
        catch (InterruptedException e) {
            throw (IOException)new InterruptedIOException().initCause(e);
        }
        catch (ExecutionException e) {
            throw (IOException)new IOException(e.getMessage()).initCause(e);
        }
        finally {
            process.destroy();
        }
        return result;
    }

    public String getLatest(String serverFolder, String localFolder, boolean force) throws IOException {
        String versionName = this.getLatestVersionName(serverFolder, localFolder);
        this.get(serverFolder, localFolder, force, "T");
        return versionName;
    }

    public void getChangeset(String serverFolder, String localFolder, boolean force, String changeset) throws IOException {
        if (StringUtil.isEmpty(changeset)) {
            throw new IllegalArgumentException("TFS changeset value is required.");
        }
        this.get(serverFolder, localFolder, force, "C" + changeset);
    }

    public void getLabel(String serverFolder, String localFolder, boolean force, String label) throws IOException {
        if (StringUtil.isEmpty(label)) {
            throw new IllegalArgumentException("label value is required.");
        }
        this.get(serverFolder, localFolder, force, "L" + label);
    }
}

