/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.command;

import com.urbancode.air.plugin.command.AzureSourceClient;
import com.urbancode.ud.client.ComponentClient;
import com.urbancode.ud.client.VersionClient;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Properties;
import java.util.UUID;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;

public class ImportVersion {
    private Properties inputProperties;
    private Properties outputProperties;
    private Logger logger;

    public ImportVersion(Properties inputProperties, Properties outputProperties) {
        this.inputProperties = inputProperties;
        this.outputProperties = outputProperties;
        this.logger = Logger.getLogger(this.getClass());
        String logLevel = inputProperties.getProperty("loggerLevel");
        Logger.getRootLogger().setLevel(Level.toLevel((String)logLevel));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int execute() throws IOException {
        int returnCode;
        block38: {
            String workspace;
            File newLocalFolder;
            boolean workspaceCreated;
            AzureSourceClient client;
            block37: {
                returnCode = 0;
                File tempDir = null;
                client = null;
                workspaceCreated = false;
                newLocalFolder = null;
                workspace = null;
                try {
                    String udVersionName;
                    Properties props = new Properties();
                    props.load(new FileInputStream(new File(System.getenv("AGENT_HOME"), "conf/agent/log4j.properties")));
                    PropertyConfigurator.configure((Properties)props);
                    Properties agentProps = new Properties();
                    agentProps.load(new FileInputStream(new File(System.getenv("AGENT_HOME"), "conf/agent/installed.properties")));
                    String charsetName = agentProps.getProperty("system.default.encoding");
                    String extensionString = this.inputProperties.getProperty("extensions");
                    String[] extensions = new String[]{};
                    if (extensionString != null) {
                        extensions = extensionString.split(",");
                        for (int i = 0; i < extensions.length; ++i) {
                            extensions[i] = extensions[i].trim();
                        }
                    }
                    Charset charset = null;
                    if (charsetName != null) {
                        charset = Charset.forName(charsetName);
                    }
                    String componentName = this.inputProperties.getProperty("componentName");
                    String repoUrl = this.inputProperties.getProperty("url");
                    String azureUsername = this.inputProperties.getProperty("username");
                    String azurePassword = this.inputProperties.getProperty("password");
                    String exePath = this.inputProperties.getProperty("tfExePath");
                    workspace = this.inputProperties.getProperty("workspace");
                    String serverFolder = this.inputProperties.getProperty("serverFolder");
                    String localFolder = this.inputProperties.getProperty("localFolder");
                    String label = this.inputProperties.getProperty("label");
                    String changeSet = this.inputProperties.getProperty("changeSet");
                    boolean saveExecutePermissions = Boolean.valueOf(this.inputProperties.getProperty("saveFileExecuteBits"));
                    boolean isUseVFS = Boolean.valueOf(this.inputProperties.getProperty("isUseVFS"));
                    String[] includes = new String[]{"**/*"};
                    String[] excludes = new String[]{};
                    if (workspace == null || workspace.isEmpty()) {
                        workspace = "azure-plugin-workspace-" + UUID.randomUUID().toString();
                        this.logger.info((Object)("[Info] `Workspace` property is empty. Generating temporary Workspace: " + workspace));
                        newLocalFolder = new File(workspace);
                        newLocalFolder.deleteOnExit();
                        localFolder = newLocalFolder.getCanonicalPath();
                        this.logger.info((Object)("[Info] Temporary Workspace Folder: " + localFolder));
                    } else if (localFolder == null || localFolder.isEmpty()) {
                        throw new RuntimeException("[Error] Both the `Workspace` and `Local Workspace Folder` properties must both be set or left empty.");
                    }
                    String username = "PasswordIsAuthToken";
                    String password = String.format("{\"token\": \"%s\"}", System.getenv("AUTH_TOKEN"));
                    String webUrl = System.getenv("AH_WEB_URL");
                    URI url = new URI(webUrl);
                    VersionClient versionClient = new VersionClient(url, username, password);
                    ComponentClient componentClient = new ComponentClient(url, username, password);
                    client = new AzureSourceClient(exePath, repoUrl, azureUsername, azurePassword);
                    if (!client.workspaceExists(workspace)) {
                        client.createWorkspace(workspace);
                        workspaceCreated = true;
                    }
                    client.mapWorkspace(workspace, serverFolder, localFolder);
                    if (label != null && label.length() > 0) {
                        udVersionName = label;
                        this.logger.info((Object)("Label: " + udVersionName));
                        client.getLabel(serverFolder, localFolder, true, label);
                    } else if (changeSet != null && changeSet.length() > 0) {
                        udVersionName = changeSet;
                        this.logger.info((Object)("Changeset: " + udVersionName));
                        client.getChangeset(serverFolder, localFolder, true, changeSet);
                    } else {
                        udVersionName = client.getLatest(serverFolder, localFolder, true);
                    }
                    List versions = componentClient.getComponentVersions(componentName, Boolean.valueOf(false));
                    boolean hasUdVersion = versions.contains(udVersionName);
                    if (!hasUdVersion) {
                        this.logger.info((Object)String.format("Creating Version: %s", udVersionName));
                        String versionId = versionClient.createVersion(componentName, udVersionName, " ", true).toString();
                        this.outputProperties.setProperty("VersionID", versionId);
                        if (isUseVFS) {
                            this.logger.info((Object)"Uploading files to VFS");
                            tempDir = new File(localFolder);
                            versionClient.addVersionFiles(componentName, udVersionName, tempDir, "", includes, excludes, saveExecutePermissions, true, charset, extensions);
                        } else {
                            this.logger.info((Object)"Skipping Artifact Upload: Component is configured not to use codestation.");
                        }
                        versionClient.markImportFinished(componentName, versionId);
                    } else {
                        this.logger.info((Object)String.format("Component Already Has Version: %s", udVersionName));
                    }
                    if (tempDir == null || !tempDir.exists()) break block37;
                    tempDir.delete();
                }
                catch (Exception e) {
                    this.logger.error((Object)String.format("Error Creating New Version: %s", e.getMessage()));
                    e.printStackTrace();
                    returnCode = 1;
                    break block38;
                }
                finally {
                    if (tempDir != null && tempDir.exists()) {
                        tempDir.delete();
                    }
                    if (workspaceCreated) {
                        try {
                            client.deleteWorkspace(workspace);
                        }
                        catch (Exception e) {
                            this.logger.error((Object)"Unable to delete temporary workspace.");
                        }
                    }
                    if (newLocalFolder != null && newLocalFolder.exists()) {
                        try {
                            this.logger.info((Object)("Deleting Local Workspace Folder: " + newLocalFolder.getCanonicalPath()));
                            FileUtils.deleteDirectory((File)newLocalFolder);
                        }
                        catch (Exception e) {
                            this.logger.error((Object)"Unable to delete temporary local workspace folder.");
                        }
                    }
                }
            }
            if (workspaceCreated) {
                try {
                    client.deleteWorkspace(workspace);
                }
                catch (Exception e) {
                    this.logger.error((Object)"Unable to delete temporary workspace.");
                }
            }
            if (newLocalFolder != null && newLocalFolder.exists()) {
                try {
                    this.logger.info((Object)("Deleting Local Workspace Folder: " + newLocalFolder.getCanonicalPath()));
                    FileUtils.deleteDirectory((File)newLocalFolder);
                }
                catch (Exception e) {
                    this.logger.error((Object)"Unable to delete temporary local workspace folder.");
                }
            }
        }
        return returnCode;
    }
}

