import com.urbancode.air.CommandHelper

final def props = new Properties();
final def inputPropsFile = new File(args[0]);
final def inputPropsStream = null;
try {
    inputPropsStream = new FileInputStream(inputPropsFile);
    props.load(inputPropsStream);
}
catch (IOException e) {
    throw new RuntimeException(e);
}
def btsTask = props['btsTask']? props['btsTask'] : 'btsTask.exe'
def application = props['application'];
def bizTalkPackage = props['bizTalkPackage'];
def database = props['database'];
def server = props['server']
def resourceSpec = props['resourceSpec']
def globalParties = props['globalParties']
try {
    def commandHelper = new CommandHelper(new File('.'));
    def args = [];
    args = [btsTask,'ExportApp', '/Package:' + bizTalkPackage];
    //optional parameters
    if (server) {
        args << '/Server:' + server
        args << server
    }
    if (database) {
        args << '/Database:' + database
    }
    if (application) {
        args << '/ApplicationName:'+ application
    }
    if (resourceSpec) {
        args << '/ResourceSpec:' + resourceSpec
    }
    if (globalParties) {
        args << '/GlobalParties:' + globalParties
    }
    commandHelper.runCommand("Exporting BizTalk application, ${application}", args);
}
catch (e) {
    println(e);
    System.exit(1);
}

