import com.urbancode.air.CommandHelper
final def props = new Properties();
final def inputPropsFile = new File(args[0]);
final def inputPropsStream = null;
try {
    inputPropsStream = new FileInputStream(inputPropsFile);
    props.load(inputPropsStream);
}
catch (IOException e) {
    throw new RuntimeException(e);
}
def btsTask = props['btsTask']? props['btsTask'] : 'btsTask.exe'
def applicationName = props['applicationName'];
def assemblyName = props['assemblyName'];
def destination = props['destination'];
def database = props['database'];
def server = props['server'];
def groupLevel = props['groupLevel'];
def globalParties = props['globalParties'];
try {
    def commandHelper = new CommandHelper(new File('.'));
    def args = [];
    args = [btsTask, 'ExportBindings', '/Destination:' + destination];
    //optional parameters
    if (server) {
        args << '/Server:' + server
    }
    if (database) {
        args << '/Database' +  database
    }
   if (groupLevel) {
        args << '/GroupLevel'
    }
    if (applicationName) {
        args << '/ApplicationName:' + applicationName
    }
    if (assemblyName) {
        args << '/AssemblyName:' + assemblyName
    }
    if (globalParties) {
        args << '/GlobalParties:' + globalParties
    }
    exitcode = commandHelper.runCommand("Exporting BizTalk application bindings for ${applicationName}", args);
    System.exit(exitcode);
    }
catch (e) {
    println (e);
    System.exit(1);
}

