
import com.urbancode.air.CommandHelper

final def props = new Properties();
final def inputPropsFile = new File(args[0]);
final def inputPropsStream = null;
try {
    inputPropsStream = new FileInputStream(inputPropsFile);
    props.load(inputPropsStream);
}
catch (IOException e) {
    throw new RuntimeException(e);
}
def powershell = props['powerShellExe']? props['powerShellExe'] : 'PowerShell.exe'
def application = props['application'];
def btDbServer = props['btDbServer'];
def btsTask = props['btsTask']? props['btsTask'] : 'btsTask.exe'
def btDatabase = props['btDatabase'];
def PLUGIN_HOME = System.getenv()['PLUGIN_HOME']
def commandHelper = new CommandHelper(new File('.'));

def psScript = PLUGIN_HOME + '\\ps_Biztalk_remove_App.ps1'
psScript = "\'${psScript}\'"
def appArg = "\'${application}\'"
def btsTaskArg = "\'${btsTask}\'"
def btDbServerArg = btDbServer ? "/S=\'${btDbServer}\'" : ""
def btDatabaseArg = btDatabase ? "/D=\'${btDatabase}\'" : ""

def args = [];
args = [powershell, "-Command", "\"& ${btsTaskArg} RemoveApp /A=${appArg} ${btDbServerArg} ${btDatabaseArg}\""]
commandHelper.runCommand("Removing BizTalk application ${appArg}: ", args);
