
import com.urbancode.air.CommandHelper

final def props = new Properties();
final def inputPropsFile = new File(args[0]);
final def inputPropsStream = null;
try {
    inputPropsStream = new FileInputStream(inputPropsFile);
    props.load(inputPropsStream);
}
catch (IOException e) {
    throw new RuntimeException(e);
}

def powershell = props['powerShellExe']? props['powerShellExe'] : 'PowerShell.exe'
def application = props['application'];
def PLUGIN_HOME = System.getenv()['PLUGIN_HOME']
def commandHelper = new CommandHelper(new File('.'));
def btDatabase = props['btDatabase'];
def btDbServer = props['btDbServer'];

def psScript = PLUGIN_HOME + '\\ps_Biztalk_start_stop_app.ps1'
psScript = "\'${psScript}\'"
def appArg =  "\'${application}\'"
def btDbServerArg = btDbServer ? "\'${btDbServer}\'" : "\'.\'"
def btDatabaseArg = btDatabase ? "\'${btDatabase}\'" : "\'BizTalkMgmtDb\'"

def args = [];
args = [powershell, "-Command", "\"& ${psScript} ${appArg} ${btDbServerArg} ${btDatabaseArg} start\""]
commandHelper.runCommand("Starting BizTalk application, '${application}': ", args);
