function app-stop {
        if ($sendports.Count -eq 0 -and $orchestrations.Count -eq 0 -and $receiveLocations.Count -eq 0) {
            Write-Host "Warning: Application contains nothing to stop"
        }

	#Stops Orchestrations
	foreach ($orchName in $orchestrations)
	{
		$orch = Get-WmiObject MSBTS_Orchestration -n root\MicrosoftBizTalkServer -filter "Name='$orchName'"
		if ($orch.OrchestrationStatus -ne "2") {
			if ($orch.OrchestrationStatus -eq "3" -or $orch.OrchestrationStatus -eq "4") {
				if ($orch.OrchestrationStatus -eq "4"){
				$orch.Stop()
				}

			$orch.Unenlist()
			}
		}
		else {
		Write-Host "Orchestration already stopped and unenlisted"
		}
	}
	#Stops Send Ports
	foreach ($portName in $sendports) {
		$sp = Get-WmiObject MSBTS_SendPort -n root\MicrosoftBizTalkServer -filter "Name='$portName'"
		if ($sp.Status -ne "1") {
			if ($sp.Status -eq "3" -or $sp.Status -eq "2") {
				if ($sp.Status -eq "2") {
				$sp.Stop()
				}

			$sp.Unenlist()
			}
		}
		else {
		Write-Host "Send ports are already disabled and stopped"
		}

	}

	#Disables receive Ports
	foreach ($locationName in $receiveLocations){
		$rec = get-wmiobject MSBTS_ReceiveLocation -n root\MicrosoftBizTalkServer -filter "ReceivePortName='$locationName'"
		$rec.Disable()
	}
}
function app-start{

        if ($sendports.Count -eq 0 -and $orchestrations.Count -eq 0 -and $receiveLocations.Count -eq 0) {
            Write-Host "Warning: Application contains nothing to start"
        }

	#Starts Send Ports
	foreach ($portName in $sendports){
		$sp = Get-WmiObject MSBTS_SendPort -n root\MicrosoftBizTalkServer -filter "Name='$portName'"
		if ($sp.Status -ne "3")	{
			if ($sp.Status -eq "1" -or $sp.Status -eq "2") {
				if ($sp.Status -eq "1") {
				    $sp.Enlist
				}
			    $sp.Start()
			}
		    else {
		        write-host "Send ports already enlisted and started"
		    }
		}
	}
	#Enables Receive locations
	foreach ($locationName in $receiveLocations) {
		$rec = get-wmiobject MSBTS_ReceiveLocation -n root\MicrosoftBizTalkServer -filter "ReceivePortName='$locationName'"
	    $rec.Enable()
	}

	#Starts Orchestrations
	foreach ($orchName in $orchestrations){
		$orch = Get-WmiObject MSBTS_Orchestration -n root\MicrosoftBizTalkServer -filter "Name='$orchName'"
		if ($orch.OrchestrationStatus -ne "4"){
			if ($orch.OrchestrationStatus -eq "2" -or $orch.OrchestrationStatus -eq "3") {
				if ($orch.OrchestrationStatus -eq "2") {
				$orch.Enlist()
				}
			$orch.Start()
			}
		}
		Else
		{
		Write-Host "Orchestration is already enlisted and started"
		}
	}
}
function host-restart {
	#restarts host instance
	$instancehost = Get-WmiObject MSBTS_HostInstance -n 'root\MicrosoftBizTalkServer' -filter HostType=1
	$instancehost.Stop()
	$instancehost.Start()
}

function get-values {
	Write-Host "Querying BizTalk Application"
	#clear array variables
	$orchestrations.Clear()
	$sendports.Clear()
	$receiveLocations.Clear()

        $btsCatExp = New-Object Microsoft.BizTalk.ExplorerOM.BtsCatalogExplorer
        $connectionString = "Integrated Security=SSPI;database="+ $btDatabase +";server="+ $btDbServer
        $btsCatExp.ConnectionString = $connectionString

	$SendPortList = $btsCatExp.Applications[$appName].SendPorts
	$OrchestrationsList = $btsCatExp.Applications[$appName].Orchestrations
	$ReceivePortList = $btsCatExp.Applications[$appName].ReceivePorts

        if ($SendPortList.Count -eq 0) {
            Write-Host "Warning: Application contains no send ports"
        }
        if ($OrchestrationsList.Count -eq 0) {
            Write-Host "Warning: Application contains no orchestrations"
        }
        if ($ReceivePortList.Count -eq 0) {
            Write-Host "Warning: Application contains no receive ports"
        }

	foreach ($i in $SendPortList) {
		$sendports.Add($i.Name)
	}
	foreach ($i in $OrchestrationsList) {
		$orchestrations.Add($i.FullName)
	}
	foreach ($i in $ReceivePortList){
		$receiveLocations.Add($i.Name)
	}
}

$appName = $args[0]
$btDbServer = $args[1]
$btDatabase = $args[2]
$command = $args[3]

$orchestrations = New-Object System.Collections.ArrayList
$sendports = New-Object System.Collections.ArrayList
$receiveLocations = New-Object System.Collections.ArrayList
[Reflection.Assembly]::LoadWithPartialName("Microsoft.BizTalk.ExplorerOM")
$btsCatExp = New-Object Microsoft.BizTalk.ExplorerOM.BtsCatalogExplorer
$connectionString = "Integrated Security=SSPI;database="+ $btDatabase +";server="+ $btDbServer
$btsCatExp.ConnectionString = $connectionString

if ($btsCatExp.Applications[$appName] -ne $null -and $command -eq "start"){
	$action = "start"
}
elseif ($btsCatExp.Applications[$appName] -ne $null -and $command -eq "stop"){
	$action = "stop"
}

Switch($action) {

	"start" {

	    get-values

	    app-start

	}


	"stop" {

	    get-values

	    app-stop

	}

	default {
	    Write-Host "Invalid application name: $appName"
            exit 1
	}
}


